#!/bin/bash

#CC=gcc
#OPTIMIZATION_FLAG="-O2 -msse2"
#C99_STD_FLAG=-std=c99
#VECTORIZATION_ON_FLAG=-ftree-vectorize
#VECTORIZATION_OFF_FLAG=""
#ASSEMBLER_OUTPUT_FLAG=-S
#LOOP_ITERATIONS=200000000

let max=$1
let i=1

cp BJTimer.h sources_vec/.
cp BJTimer.h sources_novec/.
cp no_dce.c sources_vec/.
cp no_dce.c sources_novec/.

rm -f result.txt
# Determine loop count
${CC} ${NO_UNROLL} ${OPTIMIZATION_FLAG} ${VECTORIZATION_UNIT_ENABLE} ${C99_STD_FLAG} ${VECTORIZATION_ON_FLAG} ${ASSEMBLER_OUTPUT_FLAG} loop_count.c -o loop_count.s
${CC} loop_count.s no_dce.c -o loop_count
LOOP_COUNT=`./loop_count`

#with vectorization
while [ $i -le $max ] ; do
  # With vectorization
  # Generate
  sed -e "s/STRIPLENGTH/${i}/g" template/*.c > sources_vec/veclen_${i}.c
  # Compile to assembler language
  cd sources_vec
  ${CC} ${NO_UNROLL} ${OPTIMIZATION_FLAG} ${VECTORIZATION_UNIT_ENABLE} ${C99_STD_FLAG} ${VECTORIZATION_ON_FLAG} ${ASSEMBLER_OUTPUT_FLAG} veclen_${i}.c -o veclen_${i}.s
  ${CC} veclen_${i}.s no_dce.c -o veclen_${i}
  ./veclen_${i} ${LOOP_COUNT} >> ../result.txt
  cd ..
  let i=i+1
done

let i=$max+1

#without vectorization
while [ $i -le $max ] ; do
  # DEBUG: Without vectorization 
  sed -e "s/STRIPLENGTH/${i}/g" template/*.c > sources_novec/veclen_${i}.c
  # Compile to assembler language
  cd sources_novec
  ${CC} ${OPTIMIZATION_FLAG} ${C99_STD_FLAG} ${VECTORIZATION_OFF_FLAG} ${ASSEMBLER_OUTPUT_FLAG} veclen_${i}.c -o veclen_${i}.s
  ${CC} veclen_${i}.s no_dce.c -o veclen_${i}
  ./veclen_${i} ${LOOP_COUNT} >> ../result.txt
  cd ..
  let i=i+1
done



