#include "AddCost.h"
#include <stdint.h>
#include "BlackJackTimer.h"

#define NTrials 50

extern int32_t e_int32_t_add_2(int32_t a, int32_t b);

struct result {
  double frequency_mhz;
  double time_nsecs;
};

static void measure_frequency(struct result * res) {
  int i;
  int64_t r;
  ticks t;
  int32_t v = 0;

  r = 500000;
  do {
    r *= 2;
    t = getticks();
    for (i=0; i < r; i++) {
      v += e_int32_t_add_2(3,3);
    }
    t = getticks() - t;
    t = t/1000000.0;
  } while (t < 0.2);

  r = r * 1022;

  res->frequency_mhz = (double)r / (t*1000000.0); /* mhz */
  res->time_nsecs = (t*1000000000.0)/(double)r; /*nanosecs*/
}

double AddCost()
{
  int i, j, count;
  double min_time = 0.0;
  double best_time = 0.0;
  struct result res;

  if (HeartBeat == 0)
    fprintf(stderr,"Computing cost of int32 add:");
  for (j=1;j<6;j++)
  {
    if (HeartBeat)
      fprintf(stderr,"Add Cost Trial %d\n",j);

    count = NTrials;

    measure_frequency(&res);
    min_time = res.time_nsecs;
    i = 1;
    while( count > 0)
    {
      measure_frequency(&res);
      count--;
      i++;
      if (res.time_nsecs < min_time)
      {
	min_time = res.time_nsecs;
	count = NTrials;
      }
    }
    fprintf(LogFile,"int32 add takes %f nsecs\t(%d trials).\n",min_time,i);
    if (best_time == 0.0)
      best_time = min_time;
    else if (min_time < best_time)
      best_time = min_time;
  }
  fprintf(LogFile,"-> returns add time of %f nsecs.\n",best_time);
  if (HeartBeat == 0)
    fprintf(stderr," %f\n",best_time);
  return best_time;
}

