#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <errno.h>
#include "../Lib/pace_rc_memlib.h"

#define MIN_TICKS   1000
#define TRIALS_FOR_MIN  50
#define LOWERBOUNDINWORDS  512
#define UPPERBOUNDINWORDS  8*1024*1024
#define MAX_TESTS_PER_RUN  512
#define MAX_LEVELS  50

#define CorDThreshold  1.5

#define log2(x) ((int) (log((double) x)/log(2.0)))

FILE *LogFile,  *DataFile;

/* Control flags */
int Verbose;        /* controls level of comments in LogFile */
int HeartBeat;      /* controls level of heart beats to stderr */
int Data;           /* controls generation of CSV data file */
int Debug;          /* controls level of debugging detail (to stderr) */

/* Shared Global Data items ... initialized in main() */
double TimerTick;   /* Timer resolution, expressed as a double    */
double MinTime;     /* Minimum time for any test */
double AddCostInNSecs;  /* from microbenchmark */

int    UnitSize;    /* size of an int, since tests work on C ints */
int    BigInt;      /* a very large integer */

int    GlobalTrash;  /* to defeat dead code elimination */

int L1Size;
int L1LineSize;
int PageSize;
int PreCon;

/* Prototypes for functions */ 

double  FindTimerTick();
int     FindBigInt();


/* Prototype for functions from math library */
double fmax(double x, double y);
double log(double x);

struct MemLevel {
  int Level;
  int Size;
  int SizeConfirm;
  int Associativity;
  int Granularity;
  int RelativeCost;
  double AccessCost;
};

struct MemLevel MemData[MAX_LEVELS];
int NextMemLevel;

#define LogConfirm  1
#define CorDConfirm 2
