#include "systemc.h"

SC_MODULE(updown)
{
	sc_in< bool >  P_clk;
	sc_in< bool >  P_reset;
	sc_in< bool >  P_updown;
	sc_out<sc_int<8> > P_ctr_val;

	int int_ctr_s;
	void behaviour();
	void print_res();			   

	SC_CTOR(updown) :
	P_clk("P_clk"),
	P_reset("P_reset"),
	P_updown("P_updown"),
	P_ctr_val("P_ctr_val")
	{
		int_ctr_s = 0;

		SC_METHOD(behaviour);
		sensitive_pos << P_clk;
		sensitive_pos << P_reset;

		SC_METHOD(print_res);
		sensitive << P_clk << P_reset << P_updown;
	}

};

SC_MODULE_EXPORT (updown)
