package dk.brics.extra;

/**
 * I need a struct, but I don't know how to define it in java. 
 */
class Pair {
    
    public dk.brics.automaton.State state;
    public int index;

    public Pair(dk.brics.automaton.State s, int i) {
	state = s;
	index = i;
    }
}




/**
 * Parses the input file and produces a corresponding
 * dk.brics.automaton.Automaton object. Assumes that the input file
 * stores the automaton in the format of scheck.
 */
public final class Parser {
    
    private static Parser instance = null;
    private java.util.Scanner s = null;
    private java.util.Set<Pair> states = new java.util.HashSet<Pair>();
    private dk.brics.automaton.NewAutomaton a = new dk.brics.automaton.NewAutomaton();
 
    /**
     * Protected constructor. Singleton design pattern
     */
    protected Parser() {}

    
    /**
     * Singleton design pattern
     */
    public static Parser singleton() {
	if (instance == null) {
	    return new Parser();
	}
	else {
	    return instance;
	}
    }

    
    /**
     * Parse the input file, and return the Automaton object
     */
    public dk.brics.automaton.NewAutomaton parse(String in_file_name) {
	
	java.io.File source = new java.io.File(in_file_name);
	if (! source.exists()) {
	    System.err.println("The source file " + in_file_name + " does not exist!");
	    System.exit(1);
	}
	
	try {
	    s = new java.util.Scanner(source);
	    return get_automaton();
	    	    
	} // try
	catch (java.io.IOException e) {
	    System.err.println("IOException in Parser.parse():" + e);
	    System.exit(1);
	}
	
	
	return null;
    }



    /**
     * Parse an integer from the Scanner object
     */
    int parse_int() {
	
	if (! s.hasNextInt()) {
	    System.err.println("Expected to find an integer, found instead " + s.next());
	}
	
	return s.nextInt();
    }

    

    /**
     * Parses an Automaton object from the stream associated with the Scanner object. 
     */
    dk.brics.automaton.NewAutomaton get_automaton() {
	int num_states = parse_int();
	int num_acc_cond = parse_int();
	
	// Only allow non-generalized Buechi automata
	assert (num_acc_cond == 1);
	
	while (s.hasNext()) {
	    parse_state();
	}
	return a;
    }


    /**
     * Parses a state from the input stream associated with the
     * Scanner object, and sets the internal state of the
     * corresponding brics.automaton.State objects.
     */
    void parse_state() {
	int state_id = parse_int();
	boolean is_initial = (parse_int() == 1);

	// System.out.println("state: " + state_id + ": " + is_initial);
	
	dk.brics.automaton.State state = find_state(state_id);

	if (is_initial) {
	    a.setInitialState( state );
	}
	
	int next = parse_int();
	
	// We expect non-generalized Buechi automata
	assert (next == 0 || next == -1);

	if (next == 0) {
	    // System.out.println("This state is accepting");
	    state.setAccept(true);
	    next = parse_int();
	    assert(next == -1);
	}

	// Parse the outgoing transitions
	dk.brics.automaton.Transition t = parse_transition();
	while (t != null) {
	    // System.out.println("Adding the transition");
	    state.addTransition(t);
	    t = parse_transition();
	}
    }


    /**
     * Parses a transition from the stream and creates the
     * corresponding brics.automaton.Transition object.
     */
    dk.brics.automaton.Transition parse_transition() {
	
	int destination = parse_int();
	
	// The sentinel indicating the end of transitions
	if (destination == -1) {
	    // System.out.println("No more transitions");
	    return null;
	}
	
	int guard = parse_int();
	// System.out.println("Found a transition to " + destination + " on " + guard + "(" + (char) guard + ")");
	
	return new dk.brics.automaton.Transition((char) guard, find_state(destination));
    }



    /**
     * Returns the dk.brics.automaton.State from @states with the
     * given @state_id. If such a State does not exist, it creates
     * one, adds it to @states, and returns it.
     */
    dk.brics.automaton.State find_state(int state_id) {
	
	for (java.util.Iterator<Pair> it = states.iterator();
	     it.hasNext();
	     )
	    {
		Pair p = it.next();
		if (p.index == state_id) {
		    // System.out.println("State " + state_id + " found in the set");
		    return p.state;
		}
	    }
	
	// System.out.println("State " + state_id + " created and added to the set");
	dk.brics.automaton.State state = new dk.brics.automaton.State();
	Pair p = new Pair(state, state_id);
	states.add(p);
	return state;
    }
}

