package dk.brics.automaton;

public class NewAutomaton extends Automaton {
    
    public String toStringNew() {
	StringBuilder b = new StringBuilder();
	
	java.util.Set<State> states = getStates();
	setStateNumbers(states);

	// Number of states; Number of accepting sets
	b.append(states.size()).append(" 1\n");
	
	for (dk.brics.automaton.State s : states) {
	    
	    // State id
	    b.append(s.number).append(" ");
	    
	    // Initial?
	    if (s == initial) {
		b.append("1 ");
	    }
	    else {
		b.append("0 ");
	    }

	    // The zero-th acceptance set
	    if (s.isAccept()) {
		b.append("0 ");
	    }

	    // Start enumerating transitions
	    b.append("-1 \n");
	    
	    java.util.Set<Transition> transitions = s.getTransitions();
	    
	    for (Transition t : transitions) {
		int destination = t.getDest().number;
		char cmin = t.getMin();
		char cmax = t.getMax();

		for (char c = cmin; c <= cmax; c++) {
		    b.append(destination).append(" ").append((int)c).append("\n");
		}
	    }
	    
	    // Done enumerating transitions
	    b.append("-1 \n");
	}
	
	return b.toString();
    } //toString
	
}
