package dk.brics.extra;

import java.io.BufferedWriter;
import java.io.FileWriter;



/**
 * Converts an automaton in the scheck format into a Brics
 * Automaton. Performs determinization and minimization, and outputs
 * the result in the scheck automaton format
 */
public class Minimizer {
       
    public static void main(String args[]) {
	
	String path_to_input = null;
	String path_to_output = null;
	String algo = null;
	int minAlgorithm = dk.brics.automaton.Automaton.MINIMIZE_HOPCROFT;

	
	int i = 0;
	while (i < args.length) {
	    if (args[i].equalsIgnoreCase("-in")) {
		path_to_input = args[i+1];
		i++;
	    }
	    
	    if (args[i].equalsIgnoreCase("-out")) {
		path_to_output = args[i+1];
		i++;
		
	    }
	    
	    if (args[i].equalsIgnoreCase("-algo")) {
		algo = args[i+1].toLowerCase();
		i++;
	    }

	    i++;
	}

	if (path_to_input == null || 
	    path_to_output == null ||
	    algo == null) 
	    
	    {
		print_usage();
		System.exit(1);
	    }

	if (algo.indexOf("huf")>-1)
	    minAlgorithm = dk.brics.automaton.Automaton.MINIMIZE_HUFFMAN;

	else if (algo.indexOf("hop")>-1)
	    minAlgorithm = dk.brics.automaton.Automaton.MINIMIZE_HOPCROFT;

	else if (algo.indexOf("br")>-1)
	    minAlgorithm = dk.brics.automaton.Automaton.MINIMIZE_BRZOZOWSKI;
	else {
	    System.err.println("Unknown algorithm: "+algo);
	    print_usage();
	    System.exit(1);
	}

	
	dk.brics.automaton.NewAutomaton a = Parser.singleton().parse(path_to_input);
	a.setDeterministic(false);
	a.restoreInvariant();
	a.setMinimization(minAlgorithm);
	a.minimize();

	try {
	    BufferedWriter outstream = new BufferedWriter(new FileWriter(path_to_output));
	    outstream.write(a.toStringNew());
	    outstream.flush();
	    outstream.close();
	}
	catch( java.io.IOException e ) {
	    System.err.println( "IOException while trying to write to output file " + path_to_output );
	    System.exit(1);
	}
	
    } //main



    static void print_usage() {
	System.err.println("Usage: \n" + 
			   "-in   Source file\n" + 
			   "-out  Destination file\n" + 
			   "-algo [ Huffman | Hopcroft | Brzozowski ]\n");
    }
}
