#include <iostream>
#include <fstream>
#include <string>

#include "automaton_tools.h"
#include "conversions.h"
#include "visitors/lbt_format.h"
#include "minimize.h"

void help(char*);
void get_string(char* infile, std::string* container);

int main(int argc, char** argv) {

  if (argc < 5) {
    help(argv[0]);
    exit(1);
  }
  char* in_file = 0;
  char* out_file = 0;
  
  // Parse the command line parameters
  for (int i = 1; i < argc; i++) {
    if (strcasecmp(argv[i], "-in") == 0 && (i+1) < argc) {
      in_file = argv[i+1];
    }

    if (strcasecmp(argv[i], "-out") == 0 && (i+1) < argc) {
      out_file = argv[i+1];
    }
  }

  if (in_file == 0 || out_file == 0) {
    help(argv[0]);
    exit(1);
  }

  global_params* gp = new global_params(argc, argv);
  gp->set_output_file(out_file);
  gp->set_conf_file("");

  std::string ltl;
  std::ifstream is(in_file, std::ios::binary);
  if (! is ) {
    std::cerr << "Unable to open " << in_file << " for input." << std::endl;
    exit (1);
  }
  prefix2inorder(is, &ltl);

  std::cout << "The LTL string is " << ltl << std::endl;
  
  std::ofstream os = *open_for_output(out_file);

  
  automaton_tools at;
  const spot::tgba_sba_proxy* s = at.ltl2tgba(ltl);

  
  //Symbolic transition encoding

  intermediate_rep ir;
  DICTIONARY_T* dict = new DICTIONARY_T;

  mm::conversions::sba2symb_ir(s, &ir, dict);

  std::cout << "Size of dictionary is " << dict->size() << std::endl;
  mm::output::ir2lbt(&ir, std::cout);
  
  at.cleanup();

  intermediate_rep min;
  //minimize(&ir, &min, gp);
  
  //ir2lbt(&min, os);
  close_file(& os);
  exit(0);
  
  // End symbolic transition encoding

  


  
//   intermediate_rep ir;
//   sba2intermediate_rep(s, &ir);
  
//   at.cleanup();

//   intermediate_rep min;
//   alphabetize_and_minimize(&ir, &min, &ltl, gp);
  
//   ir2lbt(&min, os);
//   os.close();
//   exit(0);
}


void help(char* prog) {
  std::cout << prog << " -in input_file_name -out output_file_name -brics_root path_to_brics_root" << std::endl;
}

/**
 * Read the contents of the file into the provided string container.
 */
void get_string(char* infile, std::string* container) {
  std::ifstream is(infile, std::ios::binary);

  if (! is) {
    std::cerr << "ERROR: Input file \"" << infile << "\" could not be opened for reading." << std::endl;
    exit(1);
  }

  getline(is, *container);
  is.close();  
}
