#include "ap_extractor.h"

// Constructor
ap_extractor::ap_extractor(sset_t* ss, bool add_par) : 
  spot::ltl::const_visitor() 
{
  container = ss;
  add_parens = add_par;
}

  
void
ap_extractor::visit (const spot::ltl::atomic_prop *node) {
  std::string name = node->name();
  if (add_parens) {
    container->insert("\"(" + name + ")\"");
  }
  else {
    container->insert("\"" + name + "\"");
  }
}


void 	
ap_extractor::visit (const spot::ltl::constant *node) {
  // do nothing
}

void 
ap_extractor::visit (const spot::ltl::binop *node) {
  node->first()->accept(*this);
  node->second()->accept(*this);
}

  
void 
ap_extractor::visit (const spot::ltl::unop *node) {
  node->child()->accept(*this);
}


void 
ap_extractor::visit (const spot::ltl::multop *node) {
  int n = node->size();
  for (int i = 0; i < n; i++) {
    node->nth(i)->accept(*this);
  }
}


//KYR added next few lines to get this to compile
void 	
ap_extractor::visit (const spot::ltl::automatop *node) {
  // do nothing
}


/**
 * Convert the string @formula_str to a SPOT::ltl::formula and then
 * use the ap_extractor visitor to get the set of atomic props.
 */
void get_ap(std::string* formula_str, sset_t* container, bool add_parens) {

  unsigned int initial_ap_count = spot::ltl::atomic_prop::instance_count();
  unsigned int initial_unop_count = spot::ltl::unop::instance_count();
  unsigned int initial_binup_count = spot::ltl::binop::instance_count();
  unsigned int initial_multop_count = spot::ltl::multop::instance_count();

  spot::ltl::parse_error_list pel;
  bool debug_spot = false;
  
  spot::ltl::environment& env(spot::ltl::default_environment::instance());
  spot::bdd_dict* dict = new spot::bdd_dict();
  
  spot::ltl::formula* f = spot::ltl::parse(formula_str->c_str(), pel, env, debug_spot);
  spot::ltl::format_parse_errors(std::cerr, formula_str->c_str(), pel);
  
  // Use the visitor, Luke
  ap_extractor apex(container, add_parens);
  f->accept(apex);
  
  // Cleanup
  if (f)
    //KYR: deprecated spot::ltl::destroy(f);
    f->destroy();  //KYR: replacement
  
  assert( spot::ltl::atomic_prop::instance_count() == initial_ap_count );
  assert( spot::ltl::unop::instance_count() == initial_unop_count );
  assert( spot::ltl::binop::instance_count() == initial_binup_count );
  assert( spot::ltl::multop::instance_count() == initial_multop_count );
  
  delete dict;
}
