#ifndef AP_EXTRACTOR
#define AP_EXTRACTOR


// For the visitor
#include <ltlast/visitor.hh>
#include <ltlast/allnodes.hh>

// For the formula parsing
#include "ltlvisit/destroy.hh"
#include "ltlparse/public.hh"
#include "tgbaalgos/dupexp.hh"

#include "types.h"

/**
 * Recursively traverse the formula tree, looking for atomic
 * propositions. Collect them in the supplied @container.
 */
class ap_extractor : public spot::ltl::const_visitor {

public:
  
  // Constructor
  ap_extractor(sset_t* ss, bool add_par = true);
  
  virtual void
  visit (const spot::ltl::atomic_prop *node);

  virtual void 	
  visit (const spot::ltl::constant *node);

  virtual void 
  visit (const spot::ltl::binop *node);

  virtual void 
  visit (const spot::ltl::unop *node);

  virtual void 
  visit (const spot::ltl::multop *node);

  virtual void 
  visit (const spot::ltl::automatop *node);

protected:
  sset_t* container;
  bool add_parens;

}; //class


/**
 * Convert the string @formula_str to a SPOT::ltl::formula and then
 * use the ap_extractor visitor to get the set of atomic props.
 */
void get_ap(std::string* formula_str, sset_t* container, bool add_par = true);


#endif
