#ifndef AUTOMATON_TOOLS_H
#define AUTOMATON_TOOLS_H

#include <string>
#include <cassert>
#include <sstream>
#include <iostream>


// SPOT includes
#include "ltlvisit/destroy.hh"
#include "ltlast/allnodes.hh"
#include "ltlparse/public.hh"
#include "tgbaalgos/ltl2tgba_lacim.hh"
#include "tgbaalgos/ltl2tgba_fm.hh"
#include "tgbaalgos/dupexp.hh"
#include "tgbaalgos/neverclaim.hh"
#include "tgbaalgos/reductgba_sim.hh"

// MM includes
#include "types.h"
#include "global_params.h"

namespace mm {
/**
 * A bag of tools for working with spot automata
 */
class automaton_tools {

 public:
  void cleanup();
  const spot::tgba_sba_proxy* ltl2tgba(std::string ltl);
  static void count_states_and_trans(const spot::tgba_sba_proxy* g, int* states, int* trans);


/*   static void generate_callbacks(const sset_t clocks_set,  */
/* 				 std::ostream &os,  */
/* 				 const std::string fun_name); */

  
  static void generate_monitor_registration_obsolete(const sset_t clocks_set, 
					    std::ostream &os,
					    const std::string obs_name);

  static void generate_mon_helpers_obsolete(std::ostream& os, const std::string formula);

  static void generate_local_observer(std::ostream&, std::ostream&, global_params* global);

  static void generate_lbt_parser(std::ostream&);


 protected:
  spot::bdd_dict* dict; //
  spot::tgba* reduced;
  spot::tgba_sba_proxy* degeneralized;
};

} // namespace mm
 
#endif


