#include "bool_global.h"

//Initialize the static data member
int
bool_operator::number_of_operators = 0;

/***************************************************
 *
 *                    Base class Bool Operator
 *
 ***************************************************/
bool_operator::bool_operator() {
  number_of_operators++;

#ifdef DEBUG
  std::cout << "bool_operator(): new operator created. Total so far: " <<number_of_operators << std::endl;
#endif

}

bool_operator::~bool_operator() {

  number_of_operators--;

#ifdef DEBUG
  std::cout << "~bool_operator(): an operator deleted. Total left: " <<number_of_operators << std::endl;
#endif

}



/***************************************************
 *
 *                    Derived class AND- operator
 *
 ***************************************************/
op_prec_t 
op_and::get_precedence() {
  return AND_PREC;
}

std::string
op_and::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  std::string to_return = f1->to_string(AND_PREC) + AND_STRING + f2->to_string(AND_PREC);
  
  if (prec < AND_PREC) {
    to_return = LPAREN_STRING + to_return + RPAREN_STRING;
  }
    
  return to_return;  
}

bool
op_and::eval(bool_formula* f1, bool_formula* f2, sbmap_t* truth_assignment) {
  bool b = f1->eval(truth_assignment);
  if (!b) {
    return false;
  }
  
  return f2->eval(truth_assignment);
}



/***************************************************
 *
 *                    Derived class OR- operator
 *
 ***************************************************/
op_prec_t 
op_or::get_precedence() {
  return OR_PREC;
}

std::string
op_or::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  std::string to_return = 
    f1->to_string(OR_PREC) 
    + OR_STRING 
    + f2->to_string(OR_PREC);
  
  if (prec < OR_PREC) {
    to_return = LPAREN_STRING + to_return + RPAREN_STRING;
  }
  
  return to_return;  
}


bool
op_or::eval(bool_formula* f1, bool_formula* f2, sbmap_t* truth_assignment) {
  bool b = f1->eval(truth_assignment);
  if (b) {
    return true;
  }
    
  return f2->eval(truth_assignment);
}


/***************************************************
 *
 *                    Derived class NOT- operator
 *
 ***************************************************/
op_prec_t 
op_not::get_precedence() {
  return NOT_PREC;
}


std::string
op_not::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  std::string to_return = NOT_STRING + f1->to_string(NOT_PREC);
  
  if (prec < NOT_PREC) {
    to_return = LPAREN_STRING + to_return + RPAREN_STRING;
  }

  return to_return;
}

bool
op_not::eval(bool_formula* f1, bool_formula* f2, sbmap_t* truth_assignment) {
  return !(f1->eval(truth_assignment));
}




/***************************************************
 *
 *                    Derived class ATOM- operator
 *
 ***************************************************/
op_atom::op_atom(std::string* a) : bool_operator() {
  atom = a;
}

op_atom::~op_atom() {
  delete atom;
}

op_prec_t 
op_atom::get_precedence() {
  return MAX_PREC;
}

std::string
op_atom::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  return "a:" + *atom;
}


bool
op_atom::eval(bool_formula* f1, bool_formula* f2, sbmap_t* truth_assignment) {

#ifdef DEBUG_BOOL_OPERATORS
  std::cout << "The truth assignment in " << __FILE__ << "::" << __func__
	    << "() for atom " << this->to_string() << ": " << std::endl;
  
  for (sbmap_t::const_iterator it = truth_assignment->begin();
	 it != truth_assignment->end();
       it ++)
    {
      std::cerr << it->first << ": " << it->second << std::endl;
    }
#endif
  
  
  if ( truth_assignment->find(*atom) == truth_assignment->end() ) {
    std::cerr << __FILE__ << "::" << __func__ << "():" << std::endl;
    std::cerr << "ERROR: atom " << *atom << ".eval() cannot return a Boolean value because" << std::endl;
    std::cerr << "the atom could not be found in the truth assignment:" << std::endl;
    
    for (sbmap_t::const_iterator it = truth_assignment->begin();
	 it != truth_assignment->end();
	 it ++)
      {
	std::cerr << it->first << ": " << it->second << std::endl;
      }
    
    exit(23);
  }
  
  return ( (*truth_assignment)[*atom] );
}


/****************************************************
 *
 *                    Derived class TRUE- operator
 *
 ***************************************************/
op_prec_t
op_true::get_precedence() {
  return MAX_PREC;
}


std::string
op_true::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  return TRUE_STRING;
}


bool
op_true::eval(bool_formula* f1, bool_formula* f2, sbmap_t*) {
  return true;
}


/****************************************************
 *
 *                    Derived class FALSE- operator
 *
 ***************************************************/
op_prec_t
op_false::get_precedence() {
  return MAX_PREC;
}


std::string
op_false::to_string(bool_formula* f1, bool_formula* f2, op_prec_t prec) {
  return FALSE_STRING;
}


bool
op_false::eval(bool_formula* f1, bool_formula* f2, sbmap_t*) {
  return false;
}
