/** 
 * Extract the states and transitions of the automaton in preparation
 * for export to Bric's Automaton tool for minimization
 */

#ifndef SBA2IR_H
#define SBA2IR_H

#include <iosfwd>
#include <ostream>
#include <sstream>
#include <string>
#include <set>
#include <cassert>


// Spot files to be included
#include "tgba/tgbatba.hh"

// MM files to be included (for the visitor)
#include "intermediate_rep.h"
#include "tostring_paren.h"
#include "utils.h"
#include "automaton_tools.h"
#include "monitor_params.h"

// Other MM files
#include "alphabetize.h"

/* #include "global_params.h" */

/* #include "types.h" */
/* #include "augment.h" */

// The includes from tgbaalgos/neverclaim.cc
#include "bdd.h"
#include "tgba/tgbatba.hh"
#include "tgba/bddprint.hh"
#include "tgbaalgos/reachiter.hh"
#include "ltlvisit/tostring.hh"
#include "tgba/formula2bdd.hh"
#include "ltlvisit/destroy.hh"

// For grabbing the atomic propositions
// #include "ltlenv/environment.hh"

namespace mm {
  namespace conversions {
#define DICTIONARY_T std::map<int, std::string>


    void sba2bool_ir(const spot::tgba_sba_proxy* s,
		     intermediate_rep* automaton);
    
    void sba2symb_ir(const spot::tgba_sba_proxy* s,
		     intermediate_rep* automaton,
		     DICTIONARY_T* dictionary);
    void sba2assign_ir(const spot::tgba_sba_proxy* s,
		       intermediate_rep* automaton,
		       v_sbmap_t* dictionary);

    void mp2bool_ir(monitor_params* mp,
		    intermediate_rep* result);
    
    //intermediate_rep* mp2intermediate_rep(monitor_params* mp);

  } // namespace conversions
} //namespace mm
#endif
