#include "back_assign_alphabetized.h"

namespace mm {
  namespace ir_visitors {

    
 /**
 * Constructor
 */ 
back_assign_alphabetized_visitor::back_assign_alphabetized_visitor(global_params* g,
								   monitor_params* m,
								   std::ostream& o,
								   std::ostream& h) :
  ir2det_monitor(g, m, o, h),
  disjunction_needed(false),
  accept_all_state_id(-1),
  active_state(-1),
  elseif_needed(false) {}

/**
 * Destructor
 */
back_assign_alphabetized_visitor::~back_assign_alphabetized_visitor() {
  // Do nothing
}


void
back_assign_alphabetized_visitor::begin(intermediate_rep* automaton) {
  num_states = automaton->size();
  monitor_header();
  monitor_constructor(automaton->get_initial_state()->get_state_id());
  step_header();
}

void
back_assign_alphabetized_visitor::process_state(state_t* state) {
  
  // See if the previous state had any transitions
  if (disjunction_needed) {
    os << ")" << std::endl
       << "	{ next_state = " << active_state << ";}" << std::endl;
  }

  disjunction_needed = false;
  
  if (state->is_accept_all()) {
    assert (accept_all_state_id == -1); // There can only be one
    accept_all_state_id = state->get_state_id();
  }

  if (state->get_num_incoming() == 0) {
    active_state = -1;
  }
  else {
    active_state = state->get_state_id();
    os << "      ";
    
    if (elseif_needed) {
      os << "else ";
    }
    elseif_needed = true;
    
    os << "if (";
  }
  
}

void
back_assign_alphabetized_visitor::process_outgoing(transition_t* trans) {
  // just chill and do nothing
}

void
back_assign_alphabetized_visitor::process_incoming(transition_t* trans) {
  
  std::set<int> indices;
  std::string guard;
  trans->get_guard(&guard);
  mm::alphabetize::trans2letters(&guard, &truth_assignments, &indices);
  assert(indices.size() == 1);

#ifdef DEBUG_BACK_ASSIGN_ALPHABETIZED
  os << "/* " << guard << "*/" << std::endl;
#endif

  if (disjunction_needed) {
    os << " ||" << std::endl << "	  ";
  }
  
  os << "( ( current_state == " << trans->get_source()
     << ") && ( system_state_index == " << *(indices.begin()) << "))";
  disjunction_needed = true;
}

void
back_assign_alphabetized_visitor::end() {
  step_footer();
  observer_callbacks();
  helper_functions();
  start_declaring_monitor_class_variables();
  finish_declaring_monitor_class_variables();
}





/**
 * Generates the end of the code for the step() function.
 */
void
back_assign_alphabetized_visitor::step_footer() {
  // See if the previous state had any transitions
  if (disjunction_needed) {
    os << ")" << std::endl
       << "   {next_state = " << active_state << ";}" << std::endl;
  }

  os << "    // Check if we are stuck... unless we already satisfied the property" << std::endl;
  os << "    bool not_stuck = (status == MON_PASS) || (next_state != -1);" << std::endl;
  os << "    if (! not_stuck) {" << std::endl;
  os << "      property_failed();" << std::endl;
  os << "    }" << std::endl;

  if (accept_all_state_id != -1) {
    // Do the "accept_all" short-circuit
    os << "    // From this state we accept anything, so we cannot get stuck" << std::endl;
    os << "    if( next_state == " << accept_all_state_id << " ) {" << std::endl;
    os << "      assert(status != MON_FAIL);" << std::endl;
    os << "      property_satisfied();" << std::endl;
    os << "    }" << std::endl;
  }  
  os << "  } // if (status == MON_UNDETERMINED)" << std::endl;
  
  os << "#ifdef MONITOR_DEBUG" << std::endl;
  os << "  else {" << std::endl;
  os << "    std::cout << \"" << this_monitor_name << ": property has already been determined to \"" << std::endl; 
  os << "              << std::string((status == MON_PASS)? \"hold\" : \"fail\") << std::endl;" << std::endl;
  os << "  }" << std::endl;
  os << "#endif" << std::endl;    
  os << "} // step()" << std::endl;
}



void
ir2back_ass_alpha(intermediate_rep* automaton,
		  global_params* global,
		  monitor_params* monitor,
		  std::ostream& output,
		  std::ostream& header_output) {
  back_assign_alphabetized_visitor visitor(global, monitor, output, header_output);
  automaton->accept(&visitor);
}

  } // namespace ir_visitors
} // namespace mm
