#include "front_det_assign_alphabetized_explicit_table.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor
 */ 
front_det_assign_alphabetized_explicit_table_visitor::front_det_assign_alphabetized_explicit_table_visitor(global_params* g,
											 monitor_params* m,
											 std::ostream& o,
											 std::ostream& h) :
  ir2det_monitor(g, m, o, h)
{

  current_state = -1;

}

/**
 * Destructor
 */
front_det_assign_alphabetized_explicit_table_visitor::~front_det_assign_alphabetized_explicit_table_visitor() {
  for (unsigned i = 0; i < num_states; i++) {
    delete transition_table[i];
  }

  delete transition_table;
}


void
front_det_assign_alphabetized_explicit_table_visitor::begin(intermediate_rep* automaton) {

  // Preconditions
  assert(automaton->is_determ());

  num_states = automaton->size();
  alphabet_size = get_alphabet_size();

  // Allocate the transition table. Deallocate in the destructor.
  transition_table = (int**) malloc(num_states * sizeof(int*));

  for (unsigned i = 0; i < num_states; i++) {
    transition_table[i] = (int*) malloc(alphabet_size * sizeof(int));

    for (unsigned j = 0; j < alphabet_size; j++) {
      transition_table[i][j] = -1;
    }
  }

  // Generate the parts of the monitor that do not depend on the lookup table
  // The lookup table itself is constructed using this visitor, and is added to the monitor in ::end()
  monitor_header();
  generate_code_for_start_of_class_definition();
  generate_code_for_start_of_monitor_constructor(automaton->get_initial_state()->get_state_id());

}

void
front_det_assign_alphabetized_explicit_table_visitor::process_state(state_t* state) {

  current_state = state->get_state_id();
}

void
front_det_assign_alphabetized_explicit_table_visitor::process_outgoing(transition_t* trans) {
  
  std::set<int> indices;
  std::string guard;
  trans->get_guard(&guard);

#ifdef DEBUG_FRONT_DET_ASSIGN_ALPHABETIZED_EXPLICIT_TABLE
  std::cout << __FILE__ << "::" << __func__ << "(): The guard for this transition is "
	    << guard << std::endl;
#endif

  mm::alphabetize::trans2letters(&guard, &truth_assignments, &indices);

  // You do not need a monitor if there are no atomic propositions in your property!
  assert(indices.size() == 1);
  transition_table[current_state][*(indices.begin())] = trans->get_dest();
}
    

void
front_det_assign_alphabetized_explicit_table_visitor::process_incoming(transition_t* trans) {
  // just chill and do nothing
}


    
void
front_det_assign_alphabetized_explicit_table_visitor::end() {

  // Generate the code to define the lookup table
  generate_code_to_declare_explicit_lookup_table(transition_table, num_states, alphabet_size);  
  generate_code_for_end_of_monitor_constructor();
  
  // Deterministic step function since ir2det_monitor is the closer parent
  step_header();
  // Insert the table-lookup
  os << "    // Lookup the next state in the table" << std::endl;
  os << "    next_state = table[current_state * " << alphabet_size <<" + system_state_index];" << std::endl;
  step_footer();
  observer_callbacks();
  helper_functions();
  start_declaring_monitor_class_variables();
  // Insert the definition of the lookup table variable
  header_os << "  // Lookup table" << std::endl;
  header_os << "  int table[" << alphabet_size * num_states << "];" << std::endl;
  finish_declaring_monitor_class_variables();
}




    

void
ir2fr_det_ass_alpha_explicit_table(intermediate_rep* automaton,
				   global_params* global,
				   monitor_params* monitor,
				   std::ostream& output,
				   std::ostream& header_output) {
  front_det_assign_alphabetized_explicit_table_visitor visitor(global, monitor, output, header_output);


  automaton->accept(&visitor); 

}

  } // namespace ir_visitors
} // namespace mm
