#include "front_det_assign_alphabetized_ifelse.h"

namespace mm {
  namespace ir_visitors {
/**
 * Constructor
 */ 
front_det_assign_alphabetized_ifelse::front_det_assign_alphabetized_ifelse(global_params* g,
									   monitor_params* m,
									   std::ostream& o,
									   std::ostream& h) :
  ir2det_monitor(g, m, o, h),
  closing_brace_for_if_needed(false),
  inner_ifstatement_needed(false),
  elseif_needed(false) {}

/**
 * Destructor
 */
front_det_assign_alphabetized_ifelse::~front_det_assign_alphabetized_ifelse() {
  // Do nothing
}


void
front_det_assign_alphabetized_ifelse::begin(intermediate_rep* automaton) {
  // Ain't gonna work for non-deterministic automata
  assert(automaton->is_determ());
  
  num_states = automaton->size();
  monitor_header();
  monitor_constructor(automaton->get_initial_state()->get_state_id());
  step_header();
}

void
front_det_assign_alphabetized_ifelse::process_state(state_t* state) {
  if (closing_brace_for_if_needed) {
    os << "      } // if (current_state == ...)" << std::endl << std::endl;
    closing_brace_for_if_needed = false;
  }

  os << "      ";
  if (elseif_needed) {
    os << "else ";
  }
  elseif_needed = true;

  os << "if (current_state == " << state->get_state_id() << ") {" << std::endl;
  os << "#ifdef MONITOR_DEBUG" << std::endl;
  os << "        std::cout << \"Current automaton state: \" << "
     << state->get_state_id() << " << std::endl;" << std::endl;
  os << "#endif" << std::endl;

  closing_brace_for_if_needed = true;
  inner_ifstatement_needed = true;
  
  if (state->is_accept_all()) {
    os << "                /* We cannot get stuck from here */" << std::endl;
    os << "                property_satisfied();" << std::endl;
    os << "              };" << std::endl;
    closing_brace_for_if_needed = false;
    inner_ifstatement_needed = false;
  }
}

void
front_det_assign_alphabetized_ifelse::process_outgoing(transition_t* trans) {
  
  std::set<int> indices;
  std::string guard;
  trans->get_guard(&guard);
  mm::alphabetize::trans2letters(&guard, &truth_assignments, &indices);
  assert(indices.size() == 1);

#ifdef DEBUG_FRONT_DET_ASSIGN_ALPHABETIZED_IFELSE
  os << "/* " << guard << "*/" << std::endl;
#endif

  if (inner_ifstatement_needed) {
    os << "        if ( system_state_index == " << *(indices.begin()) << " ) {";
    inner_ifstatement_needed = false;
  }
  else {
    os << "        else if ( system_state_index == " << *(indices.begin()) << " ) {";
  }

  os << " next_state = " << trans->get_dest() << "; }" << std::endl;
}

void
front_det_assign_alphabetized_ifelse::process_incoming(transition_t* trans) {
  // just chill and do nothing
}

void
front_det_assign_alphabetized_ifelse::end() {
  step_footer();
  observer_callbacks();
  helper_functions();
  start_declaring_monitor_class_variables();
  finish_declaring_monitor_class_variables();
}



/**
 * Generates the end of the code for the step() function.
 */
void
front_det_assign_alphabetized_ifelse::step_footer() {
  if (closing_brace_for_if_needed) {
    os << "      } // if" << std::endl << std::endl;
    closing_brace_for_if_needed = false;
  }
  
  ir2det_monitor::step_footer();
}



void
ir2fr_det_ass_alpha_ifelse(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output) {
  front_det_assign_alphabetized_ifelse visitor(global, monitor, output, header_output);
  automaton->accept(&visitor);
}

  } // namespace ir_visitors
} // namespace mm
