#include "front_det_assign_alphabetized_switch.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor
 */ 
front_det_assign_alphabetized_switch_visitor::front_det_assign_alphabetized_switch_visitor(global_params* g,
											   monitor_params* m,
											   std::ostream& o,
											   std::ostream& h) :
  ir2det_monitor(g, m, o, h),
  closing_brace_for_if_needed(false),
  closing_brace_for_switch_needed(false),
  start_outer_switch(true) {}

/**
 * Destructor
 */
front_det_assign_alphabetized_switch_visitor::~front_det_assign_alphabetized_switch_visitor() {
  // Do nothing
}


void
front_det_assign_alphabetized_switch_visitor::begin(intermediate_rep* automaton) {
  // Ain't gonna work for non-deterministic automata
  assert(automaton->is_determ());
  
  num_states = automaton->size();
  monitor_header();
  monitor_constructor(automaton->get_initial_state()->get_state_id());
  step_header();
}

void
front_det_assign_alphabetized_switch_visitor::process_state(state_t* state) {
  if (closing_brace_for_switch_needed) {
    os << "          } // inner switch/case" << std::endl;
    closing_brace_for_switch_needed = false;
  }

  if (closing_brace_for_if_needed) {    
    os << "        break; // the outer case" << std::endl << std::endl;
    closing_brace_for_if_needed = false;
  }

  if (start_outer_switch) {
    os << "      switch (current_state) {" << std::endl;
    start_outer_switch = false;
  }
  
  os << "        case " << state->get_state_id() << ": " << std::endl;
  os << "#ifdef MONITOR_DEBUG" << std::endl;
  os << "          std::cout << \"Current automaton state: "
     << state->get_state_id() << "\" << std::endl;" << std::endl;
  os << "#endif" << std::endl;
  
  closing_brace_for_if_needed = true;
  t_switch_needed = true;
  assert(closing_brace_for_switch_needed == false);
  
  if (state->is_accept_all()) {
    os << "      /* We cannot get stuck from here */" << std::endl;
    os << "      property_satisfied();" << std::endl;
    os << "    break; // the outer switch/case" << std::endl;
    closing_brace_for_if_needed = false;
    t_switch_needed = false;
  }
}

void
front_det_assign_alphabetized_switch_visitor::process_outgoing(transition_t* trans) {
  
  std::set<int> indices;
  std::string guard;
  trans->get_guard(&guard);

#ifdef DEBUG_FRONT_DET_ASSIGN_ALPHABETIZED_SWITCH
  std::cout << __FILE__ << "::" << __func__ << "(): The guard for this transition is "
	    << guard << std::endl;
#endif

  
  
  mm::alphabetize::trans2letters(&guard, &truth_assignments, &indices);

  if (indices.size() == 0) {
    assert(truth_assignments.size() == 1);
    assert((truth_assignments[0])->size() == 0);

#ifdef DEBUG_FRONT_DET_ASSIGN_ALPHABETIZED_SWITCH
    std::cout << __FILE__ << "::" << __func__ << "(): It seems that we are dealing with an automaton without atomic propositions. " << std::endl;
    std::cout << __FILE__ << "::" << __func__ << "(): The state index is thus always 0, and the guard is a pure true/false value" << std::endl;
#endif
    
    if (guard.compare("0")) {
      indices.insert(999);
    }
    else if (guard.compare("1")) {
      indices.insert(0); // match the state index
    }
    else {
      std::cerr << "Incorrect assumption that the guard ->" << guard << "<- is a pure true/false value in " << std::endl;
      std::cout << __FILE__ << "::" << __func__ << "()";
      exit(23);
    }
  }
  
  assert(indices.size() == 1);



  if (t_switch_needed) {
    os << "          switch ( system_state_index ) {" << std::endl;
    t_switch_needed = false;
    closing_brace_for_switch_needed = true;
  }
  
  os << "            case ";
  // The "letter" corresponding to the transition is the system_state_index
  os << *(indices.begin()) << ": next_state = " << trans->get_dest() << "; break;" << std::endl;
}

void
front_det_assign_alphabetized_switch_visitor::process_incoming(transition_t* trans) {
  // just chill and do nothing
}

void
front_det_assign_alphabetized_switch_visitor::end() {
  step_footer();
  observer_callbacks();
  helper_functions();
  start_declaring_monitor_class_variables();
  finish_declaring_monitor_class_variables();
}





/**
 * Generates the end of the code for the step() function.
 */
void
front_det_assign_alphabetized_switch_visitor::step_footer() {
  if (closing_brace_for_switch_needed) {
    os << "          } // inner switch/case" << std::endl;
    closing_brace_for_switch_needed = false;
  }
  if (closing_brace_for_if_needed) {
    os << "        break; // the outer switch/case" << std::endl << std::endl;
    closing_brace_for_if_needed = false;
  }

  if (start_outer_switch == false) {
    os << "      } // switch (current_state)" << std::endl << std::endl;
  }

  ir2det_monitor::step_footer();
}



void
ir2fr_det_ass_alpha_switch(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output) {
  front_det_assign_alphabetized_switch_visitor visitor(global, monitor, output, header_output);

  automaton->accept(&visitor);
}

  } // namespace ir_visitors
} // namespace mm
