#include "front_det_assign_alphabetized_table.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor
 */ 
front_det_assign_alphabetized_table_visitor::front_det_assign_alphabetized_table_visitor(global_params* g,
											 monitor_params* m,
											 std::ostream& o,
											 std::ostream& h) :
  ir2det_monitor(g, m, o, h)
{

  // Holds only if we have not seen any states so far.
  seen_any_states = false;

  // Determine where to output the LBT automaton
  std::string lbt_file;
  get_unique_file_name_in_same_directory(new std::string(gp->get_header_output_file()),
					 "automaton",
					 "lbt",
					 &lbt_file);
  mp->set_lbt_file(new std::string(lbt_file));
  lbt_automaton_os = open_for_output(lbt_file.c_str());
}

/**
 * Destructor
 */
front_det_assign_alphabetized_table_visitor::~front_det_assign_alphabetized_table_visitor() {
  // Do nothing
}


void
front_det_assign_alphabetized_table_visitor::begin(intermediate_rep* automaton) {

  // Preconditions
  assert(automaton->is_determ());

  // First generate the relevant portions of the monitor class
  monitor_header();
  generate_code_for_start_of_class_definition();
  generate_code_for_start_of_monitor_constructor(automaton->get_initial_state()->get_state_id());
  generate_code_to_declare_lookup_table();
  generate_code_for_end_of_monitor_constructor();
  // Deterministic step function since ir2det_monitor is the closer parent
  step_header();
  // Insert the table-lookup
  os << "    // Lookup the next state in the table" << std::endl;
  os << "    next_state = table[current_state][system_state_index];" << std::endl;
  step_footer();
  observer_callbacks();
  helper_functions();
  start_declaring_monitor_class_variables();
  // Insert the definition of the lookup table variable
  header_os << "  // Lookup table" << std::endl;
  header_os << "  int** table;" << std::endl;
  finish_declaring_monitor_class_variables();

  // Now the rest of the visitor is taking care of the LBT file
  num_states = automaton->size(); 
  //print lbt num_states here 
  *lbt_automaton_os << num_states << " ";
  //number of accepting sets is always 1 
  *lbt_automaton_os << 1 << std::endl;
}

void
front_det_assign_alphabetized_table_visitor::process_state(state_t* state) {

  //lbt:
  // get the state object's number
  // query the state object whether initial and whether accepting
  // example: 0 0 0 -1 //state 0 is not initial and not accepting

  //end the last state
  if (seen_any_states) {
    *lbt_automaton_os << "-1" << std::endl;
  } //end if
  
  seen_any_states = true;
  
  *lbt_automaton_os << state->get_state_id()
		    << " " << state->is_initial()
		    << " " << (state->is_accepting() ? "0 " : "")
		    << "-1" << std::endl;
}

void
front_det_assign_alphabetized_table_visitor::process_outgoing(transition_t* trans) {
  
  std::set<int> indices;
  std::string guard;
  trans->get_guard(&guard);

#ifdef DEBUG_FRONT_DET_ASSIGN_ALPHABETIZED_TABLE
  std::cout << __FILE__ << "::" << __func__ << "(): The guard for this transition is "
	    << guard << std::endl;
#endif

  mm::alphabetize::trans2letters(&guard, &truth_assignments, &indices);

  // You do not need a monitor if there are no atomic propositions in your property!
  assert(indices.size() == 1);
  *lbt_automaton_os << trans->get_dest() << " " << *(indices.begin()) << std::endl;
}

void
front_det_assign_alphabetized_table_visitor::process_incoming(transition_t* trans) {
  // just chill and do nothing
}


    
void
front_det_assign_alphabetized_table_visitor::end() {

  //lbt ends the last state
  if (seen_any_states) {
    *lbt_automaton_os << "-1" << std::endl;
  } //end if
}




    

void
ir2fr_det_ass_alpha_table(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output) {
  front_det_assign_alphabetized_table_visitor visitor(global, monitor, output, header_output);


  automaton->accept(&visitor); 

}

  } // namespace ir_visitors
} // namespace mm
