#include "front_nondeterministic.h"

namespace mm {
  namespace ir_visitors {
    /**
     * Constructor
     */ 
    front_nondeterministic_visitor::front_nondeterministic_visitor(global_params* g,
								   monitor_params* m,
								   std::ostream& o,
								   std::ostream& h) :
      ir2monitor(g, m, o, h, true),
      outer_if_closing_brace_needed(false),
      accept_all_state_index(-1)    { 
      // Do nothing
    } //end front_nondeterministic_visitor constructor
    
    /**
     * Destructor
     */
    front_nondeterministic_visitor::~front_nondeterministic_visitor() {
      // Do nothing
    } //end ~front_nondeterministic_visitor
    

    void
    front_nondeterministic_visitor::begin(intermediate_rep* automaton) {
      num_states = automaton->size();
      
      monitor_header();
      monitor_constructor(automaton->get_initial_state()->get_state_id());
      step_header();
    } //end begin()

    void
    front_nondeterministic_visitor::process_state(state_t* state) {
      if (outer_if_closing_brace_needed) {
	os << "      } // if" << std::endl << std::endl;
      }
      
      os << "      if (current_state[" << state->get_state_id() << "]) {" << std::endl;
      os << "#ifdef MONITOR_DEBUG" << std::endl;
      os << "        std::cout << \"Current microstate: "
	 << state->get_state_id() << "\" << std::endl;" << std::endl;
      os << "#endif" << std::endl;
      outer_if_closing_brace_needed = true;
      
      if (state->is_accept_all()) {
	os << "        // This line should be unreachable" << std::endl;
	os << "        property_satisfied();" << std::endl;
	os << "      };" << std::endl;
	outer_if_closing_brace_needed = false;
	accept_all_state_index = state->get_state_id();
      } //end if
    } //end process_state

    void
    front_nondeterministic_visitor::process_outgoing(transition_t* trans) {
      
      // Accept_all states close the outer-if statement brace, so the
      // if-statement here would be outside the outer if-statement
      if (outer_if_closing_brace_needed == true) {
	os << "        if(";
	
	// Remove the quotes and print the guard to the stream
	remove_str(trans->get_guard(), "\"'", os);
	os << "  )" << std::endl;
	os << "          next_state[" << trans->get_dest() << "] = 1;" << std::endl;
      } //end if
    } //end process_outgoing
    
    void
    front_nondeterministic_visitor::process_incoming(transition_t* trans) {
      // just chill and do nothing
    } //end process_incoming
    
    void
    front_nondeterministic_visitor::end() {
      step_footer();
      observer_callbacks();
      helper_functions();
      start_declaring_monitor_class_variables();
      finish_declaring_monitor_class_variables();
    } //end end()
    





    /**
     * Generates the end of the code for the step() function.
     */
    void
    front_nondeterministic_visitor::step_footer() {
      if (outer_if_closing_brace_needed) {
	os << "      } // if" << std::endl << std::endl;
      } //end if
      
      os << std::endl;
      if (accept_all_state_index != -1) {
	// Add the short-circuit on the next_state vector
	os << "    if (next_state[" << accept_all_state_index << "]) {" << std::endl;
	os << "      property_satisfied();" << std::endl;
	os << "    }" << std::endl << std::endl;
      } //end if
      os << "    // Check if we are stuck... unless we already satisfied the property" << std::endl;
      os << "    bool not_stuck = (status == MON_PASS);" << std::endl;
      os << "    for (int i = 0; i < " << num_states << "; i++) {" << std::endl;
      os << "      not_stuck = not_stuck || next_state[i];" << std::endl;
      os << "    }" << std::endl << std::endl;
      os << "    if (! not_stuck) {" << std::endl;
      os << "      property_failed();" << std::endl;
      os << "    }" << std::endl;
      os << "  } // if (status == MON_UNDETERMINED)" << std::endl;
      os << "#ifdef MONITOR_DEBUG" << std::endl;
      os << "  else {" << std::endl;
      os << "    std::cout << \"" << this_monitor_name << ": property has already been determined to \"" << std::endl; 
      os << "              << std::string((status == MON_PASS)? \"hold\" : \"fail\") << std::endl;" << std::endl;
      os << "  }" << std::endl;
      os << "#endif" << std::endl;    
      os << "} // step()" << std::endl;
    } //end step_footer()


    
    //Called by main.cc:generate_monitors() if the monitor encoding is set to FRONT_NONDET
    void
    ir2fr_nondet(intermediate_rep* automaton,
		 global_params* global,
		 monitor_params* monitor,
		 std::ostream& output,
		 std::ostream& header_output) {
#ifdef DEBUG_FRONT_NONDETERMINISTIC
      std::cout << __FILE__ << ": " << __func__ << " "
		<<"Generating a front non-deterministic automaton" << std::endl;
#endif
      //call the constructor and create a new visitor
      front_nondeterministic_visitor visitor(global, monitor, output, header_output);

      //call a function outside this file, which then calls the functions inside this file
      // - calls begin, end, process_outgoing, process_incoming:
      automaton->accept(&visitor); //intermediate_rep.cc
      
#ifdef DEBUG_FRONT_NONDETERMINISTIC
      std::cout << __FILE__ << ": " << __func__ << " "
		<< "Done generating a front non-deterministic automaton" << std::endl;
#endif
    } //end ir2fr_nondet()
    
  } // namespace ir_visitors
} // namespace mm
