#include "ir2det_monitor.h"

namespace mm {
  namespace ir_visitors {

/*
 * The constructor
 */
ir2det_monitor::ir2det_monitor(global_params* g,
			       monitor_params* m,
			       std::ostream& o,
			       std::ostream& h) :
  ir2monitor(g, m, o, h, false)
{
  // Extract the atomic propositions in this monitor
  std::string ltl_string;
  mp->get_ltl(&ltl_string);
  mm::alphabetize::get_ap_vector(&ltl_string, &atoms_vector);

  // All possible truth assignments to the atoms in @atoms_vector
  mm::alphabetize::vector2assgnmts(&atoms_vector, &truth_assignments);
}


/**
 * Generates the code to setup the beginning of the step()
 * function. Swaps the values of current state and next state, zeroes
 * out the next state, and starts the iteration over the states.
 */
void
ir2det_monitor::step_header() {
  header_os << std::endl << "  void step();" << std::endl;
  os << "/**" << std::endl;
  os << "* Simulate a step of the monitor." << std::endl;
  os << "*/" << std::endl;
  os << "void" << std::endl;
  os << this_monitor_name << "::step() {" << std::endl;
  os << "  if (status == MON_UNDETERMINED) {" << std::endl;
  os << "    num_steps++; //debug: check the monitor explores the same length path" << std::endl;
  os << "    current_state = next_state; // here we do the swap of current_state and next_state" << std::endl << std::endl;
  os << "    next_state = -1;" << std::endl << std::endl;
  
  // Calculate the system_state index
  os << "    // Calculate the system state index" << std::endl;
  //os << "    int system_state_index = 0;" << std::endl;
  os << "    unsigned int system_state_index = 0;" << std::endl; //KYR

  int num_atomic = atoms_vector.size();
  for (unsigned int i = 0; i < atoms_vector.size(); i++) {
    std::string atom_with_quotes = atoms_vector[i];
    std::string atom_without_quotes;
    remove_str(&atom_with_quotes, "\"", &atom_without_quotes);
    os << "    system_state_index += " << atom_without_quotes << " ? (1 << " //KYR
      //os << "    system_state_index += " << atom_without_quotes << " ? (1 << "
       << num_atomic - i - 1 <<") : 0;" << std::endl ;
  }
  os << std::endl;
}


/**
 * Generates the code at the end of the step function
 */
void
ir2det_monitor::step_footer() {
  os << std::endl;
  os << "    // Check if we are stuck... unless we already satisfied the property" << std::endl;
  os << "    bool not_stuck = (status == MON_PASS) || (next_state != -1);" << std::endl;
  os << "    if (! not_stuck) {" << std::endl;
  os << "      property_failed();" << std::endl;
  os << "    }" << std::endl;
  os << "  } // if (status == MON_UNDETERMINED)" << std::endl;
  os << "#ifdef MONITOR_DEBUG" << std::endl;
  os << "  else {" << std::endl;
  os << "    std::cout << \"" << this_monitor_name << ": property has already been determined to \"" << std::endl; 
  os << "              << std::string((status == MON_PASS)? \"hold\" : \"fail\") << std::endl;" << std::endl;
  os << "  }" << std::endl;
  os << "#endif" << std::endl;    
  os << "} // step()" << std::endl;
}

  } // namespace ir_visitors
} // namespace mm
