#ifndef IR2DET_MONITOR_H
#define IR2DET_MONITOR_H

#include "ir2monitor.h"

namespace mm {
  namespace ir_visitors {

/**
 * The base class for creating deterministic monitors.
 */
class ir2det_monitor : public ir2monitor {

 public:

  // Constructor
  ir2det_monitor(global_params* g,
		 monitor_params* m,
		 std::ostream& o,
		 std::ostream& h);

  // Virtual destructor
  virtual ~ir2det_monitor() {};
  
  // Generate code for calculating the integer state of the system
  void step_header();
  void step_footer();

 protected:
  svector_t atoms_vector;
  v_sbmap_t truth_assignments;
  
}; // class
    
  } // namespace ir_visitors
} // namespace mm


#endif

