#include "ir_state_trans_counter.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor
 */
ir_state_trans_counter_visitor::ir_state_trans_counter_visitor(int* state_count,
							       int* trans_count) :
  ir_visitor(),
  num_states(state_count),
  num_trans(trans_count)
{
  incoming_trans = 0;
}


void
ir_state_trans_counter_visitor::process_state(state_t* state) {
  (*num_states)++;
}

void
ir_state_trans_counter_visitor::process_outgoing(transition_t* trans) {
  (*num_trans)++;
}

void    
ir_state_trans_counter_visitor::process_incoming(transition_t* trans) {
  incoming_trans++;
}

void    
ir_state_trans_counter_visitor::end() {
  if (incoming_trans != *num_trans) {
    std::cerr << __FILE__ << ":" << __func__ << ":" << std::endl;
    std::cerr << "Discrepancy between the number of incoming and the number of outgoing transitions." << std::endl;
    std::cerr << "Counted " << incoming_trans << " incoming and " << (*num_trans) << " outgoing transitions."<< std::endl;
    std::cerr << "Perhaps you need to restore_invariant() after you create the IR?" << std::endl;
    exit(1);
  }
}


/**
 * Counts the number of states and transitions in the IR using a
 * visitor.
 */
void count_ir_state_trans(intermediate_rep* ir, int* states, int* trans) {
  
  ir_state_trans_counter_visitor v(states, trans);
  ir->accept(&v);
}
    
  } // namespace ir_visitors
} // namespace mm
