#ifndef LBT_FORMAT_H
#define LBT_FORMAT_H

#include <iostream>

#include "ir_visitor.h"

namespace mm {
  namespace ir_visitors {
    
/**
 * Print out the automaton in the LBT format
 * (http://www.tcs.hut.fi/Software/maria/tools/lbt/).
 */
class lbt_format_visitor : public mm::ir_visitors::ir_visitor {

 public:
  // Constructor
  lbt_format_visitor(std::ostream& str);
  // Destructor
  virtual ~lbt_format_visitor();
  
  virtual void begin(intermediate_rep* automaton);
  virtual void process_state(state_t* state);
  virtual void process_outgoing(transition_t* trans);
  virtual void process_incoming(transition_t* trans);
  virtual void end();

 private:
  std::ostream& os;
  bool bookend;
};


 void ir2lbt(intermediate_rep* automaton, std::ostream& str = std::cout);

    
  } //namespace ir_visitors
} // namespace mm

#endif
