#include "front_nondeterministic.h"
#include "front_det_assign_alphabetized_switch.h"
#include "front_det_assign_alphabetized_ifelse.h"
#include "front_det_assign_alphabetized_table.h"  //KYR
#include "back_nondeterministic.h"
#include "back_assign_alphabetized.h"

namespace mm {
  namespace ir_visitors {

// front_nondeterministic.cc
void
ir2fr_nondet(intermediate_rep* automaton,
	     global_params* global,
	     monitor_params* monitor,
	     std::ostream& output,
	     std::ostream& header_output);


void
ir2fr_det_ass_alpha_switch(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output);



void
ir2fr_det_ass_alpha_ifelse(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output); 
 
void
ir2fr_det_ass_alpha_table(intermediate_rep* automaton,
			   global_params* global,
			   monitor_params* monitor,
			   std::ostream& output,
			   std::ostream& header_output);

void
ir2fr_det_ass_alpha_explicit_table(intermediate_rep* automaton,
				   global_params* global,
				   monitor_params* monitor,
				   std::ostream& output,
				   std::ostream& header_output);
void
ir2back_nondet(intermediate_rep* automaton,
	       global_params* global,
	       monitor_params* monitor,
	       std::ostream& output,
	       std::ostream& header_output);


void
ir2back_ass_alpha(intermediate_rep* automaton,
		  global_params* global,
		  monitor_params* monitor,
		  std::ostream& output,
		  std::ostream& header_output);

 
  } // namespace ir_visitors
} // namespace mm
