#include "trans_relabeler.h"

namespace mm {
  namespace ir_visitors {

/**
 * Constructor. The truth assignment vector @ta contains the
 * information needed for the translation.
 */
trans_relabeler_ta::trans_relabeler_ta(v_sbmap_t* truth_assignment) {
  ta = truth_assignment;
}


//Destructor
trans_relabeler_ta::~trans_relabeler_ta() {}


void
trans_relabeler_ta::process_outgoing(transition_t* trans) {
  std::string curr_guard;
  trans->get_guard(&curr_guard);
  
#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << "(): executing with transition "
	    << trans->to_string() << std::endl;
#endif
  
  int truth_index = str2int(curr_guard);

  
  
  std::string new_guard;

#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << "(): the vector with truth assignments has size "
	    << ta->size() << std::endl;
#endif

  
  std::map<std::string,bool>* truth_assignment = ta->at(truth_index);

#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << "(): The truth assignment is " << std::endl;
  
  for (std::map<std::string,bool>::const_iterator it = truth_assignment->begin();
       it != truth_assignment->end();
       it ++)
    {
      std::cout << "->" << it->first << "<-: ->" << it->second << "<-" << std::endl;
    }

  std::cout << __FILE__ << "::" << __func__ << "(): The truth assignment map has size "
	    << truth_assignment->size() << std::endl;
#endif

  if (truth_assignment->size() > 0) {
    for (std::map<std::string, bool>::const_iterator it = truth_assignment->begin();
	 it != truth_assignment->end();
	 it ++)
      {
	if (it != truth_assignment->begin()) {
	  new_guard += " && ";
	}
	
	if (! it->second) {
	  new_guard += "!";
	}
	
	// No need for parens around the atoms
	new_guard += "" + it->first + "";
      }
  }
  else {
    // If the truth assignment map has zero elements, it must be
    // because there are no atomic propositions in the formula. Thus,
    // the guard on this transition is a pure "true" or "false"
    // value. We pass it truth without change.
    new_guard = curr_guard;
  }

    trans->reset_guard(new_guard);

#ifdef DEBUG_TRANS_RELABELER
  std::cout << "Reset the guard with this one ->" << new_guard << "<-" << std::endl;
  std::cout << __FILE__ << "::" << __func__ << "(): the new transition is "
	    << trans->to_string() << std::endl;
#endif
  
}





/**
 * Constructor. The dictionary vector @dict contains the information
 * needed for the translation.
 */
trans_relabeler_bdd::trans_relabeler_bdd(std::map<int, std::string>* d) {
  dict = d;
}


// Destructor
trans_relabeler_bdd::~trans_relabeler_bdd() {}


void
trans_relabeler_bdd::process_outgoing(transition_t* trans) {
  std::string curr_guard;
  trans->get_guard(&curr_guard);

#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << ":" << std::endl
	    << "The guard is " << curr_guard << std::endl;
#endif    

  int bdd_index = str2int(curr_guard);

#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << ":" << std::endl
	    << "The BDD index for this guard is " << bdd_index << std::endl;
#endif    
  
  std::string new_guard = (*dict)[bdd_index];

#ifdef DEBUG_TRANS_RELABELER
  std::cout << __FILE__ << "::" << __func__ << ":" << std::endl
	    << "The Boolean function for this guard is " << new_guard << std::endl << std::endl;
#endif  
  trans->reset_guard(new_guard);
}



/**
 * And finally, the factory functions
 */
trans_relabeler_ta*
relabeling_visitor_factory(v_sbmap_t* ta) {
  return new trans_relabeler_ta(ta);
}


trans_relabeler_bdd*
relabeling_visitor_factory(std::map<int, std::string>* dict) {
  return new trans_relabeler_bdd(dict);
}


  } // namespace ir_visitors
} // namespace mm
