#ifndef TRANS_RELABELER_H
#define TRANS_RELABELER_H


#include "ir_visitor.h"
#include "types.h"
#include "utils.h"

namespace mm {
  namespace ir_visitors {
    
/**
 * IR visitor that relabels transitions. Each transition is assumed to
 * be an integer. The truth assignments vector @ta provides the
 * dictionary for translating from int to Boolean assignment to
 * Boolean function.
 */
class trans_relabeler_ta : public mm::ir_visitors::ir_visitor {

 public:
  /**
   * Constructor. The truth assignment vector @ta contains the
   * information needed for the translation.
   */
  trans_relabeler_ta(v_sbmap_t* truth_assignment);

  // Destructor
  virtual ~trans_relabeler_ta();
  
  virtual void process_outgoing(transition_t* trans);

 protected:
  v_sbmap_t* ta;
};






/**
 * IR visitor that relabels transitions. Each transition is assumed to
 * be an integer. The dictionary vector @dict provides the dictionary
 * for translating from int to (Boolean function) strings
 */
class trans_relabeler_bdd : public mm::ir_visitors::ir_visitor {

 public:
  /**
   * Constructor. The dictionary vector @dict contains the
   * information needed for the translation.
   */
  trans_relabeler_bdd(std::map<int, std::string>* d);

  // Destructor
  virtual ~trans_relabeler_bdd();
  
  virtual void process_outgoing(transition_t* trans);


 protected:
  std::map<int, std::string>* dict;
};


trans_relabeler_ta*  relabeling_visitor_factory(v_sbmap_t* ta);
trans_relabeler_bdd* relabeling_visitor_factory(std::map<int, std::string>* dict);

  } // namespace ir_visitors
} // namespace mm

#endif
