#include <string>
#include <iostream>
#include <fstream>

class lbt_parser {

public:

  /**
   * Reads an integer from the file associated with this parser, and
   * returns it.
   */
  int
  parse_int() {
    std::string str;
    *input_stream >> str;
    return atoi(str.c_str());
  }


  /**
   * Returns true if the file stream @in_strm has any integers left.
   */
  bool
  has_int() {

    // Save where we are in the file in case we need to roll back
    std::streampos current = input_stream->tellg();

    std::string str;
    *input_stream >> str;

    if (str.length() == 0) {
      return false;
    }

    // Undo and return
    input_stream->seekg(current);
    return true;
  }


  /**
   * Parses a transition from the input file and stores it in the
   * lookup table. Returns false if there are no more transitions for
   * the current state, otherwise returns true.
   */
  bool
  parse_transition() {

    int destination = parse_int();

    if (destination == -1)
      return false;

    int guard = parse_int();
    transition_table[current_state][guard] = destination;
    return true;
  }
    
  

  /**
   * Parses one state and its associated transitions.
   */
  void
  parse_state() {
    current_state = parse_int();

    // Is it initial?
    parse_int();

    // Is it accepting?
    int acceptance = parse_int();

    // If it is accepting, we need to consume the remaining -1 before
    // we start parsing the transitions
    if (acceptance == 0) {
      parse_int();
    }

    while(parse_transition());
  }
  

  /**
   * Reads the automaton from the file indicated by @source, and
   * returns a transition lookup table corresponding to the
   * transitions of the automaton.
   */
  int**
  parse_to_table(const char* source, int alphabet_size) {
    
    input_stream = new std::ifstream(source, std::ios::in);
    
    if (! input_stream ) {
      std::cerr << "Unable to open \"" << source << "\" for input." << std::endl;
      exit (1);
    }

    unsigned int automaton_num_states = parse_int();

    // Consume the number of acceptance sets from the input file, but
    // we do not need to store them.
    parse_int();

    transition_table = (int**) malloc(automaton_num_states * sizeof(int*));

    for (int i = 0; i < alphabet_size; i++) {
      transition_table[i] = (int*) malloc(alphabet_size * sizeof(int));

      for (int j = 0; j < alphabet_size; j++) {
	transition_table[i][j] = -1;
      }
    }
      
    while (has_int()) {
      parse_state();
    }
    
    return transition_table;
  }


protected:

  // Transition lookup table
  int** transition_table;

  // Source file from which we read the automaton
  std::ifstream* input_stream;

  // The state for which we are generating transitions
  int current_state;
  
};
