#include "minimize.h"
#include "conversions.h"
#include "global_params.h"
#include "alphabetize.h"
#include "visitors/front_nondeterministic.h"
#include "visitors/front_deterministic.h"
#include "visitors/back_nondeterministic.h"
#include "visitors/back_simplified.h"
#include "visitors/lbt_format.h"
#include "front_mon_gen.h"

void truth_assgn_to_string(sbmap_t* ta) {
  for (sbmap_t::const_iterator it = ta->begin();
       it != ta->end();
       it ++)
    {
      std::cout << it->first << ": " << it->second << std::endl;
    }
}



void test_assignments(std::string formula) {
  
  v_sbmap_t truth_assgn;
  form2assgnmts(&formula, &truth_assgn);
  
  for (unsigned int i = 0; i<truth_assgn.size(); i++) {
    std::cout << "Assignment " << i << std::endl;
    truth_assgn_to_string(truth_assgn[i]);
    std::cout << std::endl;
  }
}



int main(int argc, char** argv) {
  
  global_params* gp = new global_params(argc, argv);
  gp->to_stream(std::cout);

  exit(0);

  mpset_t::const_iterator it = gp->all_monitors.begin();
  monitor_params* mp = *it;
  
  std::string ltl_string;
  mp->get_ltl(&ltl_string);

  //test_assignments(ltl_string);
  
  std::ofstream out_strm;
  
  // LTL -> SPOT -> IR
  automaton_tools at;
  const spot::tgba_sba_proxy* s = at.ltl2tgba(ltl_string);
  intermediate_rep* ea = new intermediate_rep();
  sba2intermediate_rep(s, ea);
  at.cleanup();

  std::cout << "After LTL -> SPOT -> IR" << std::endl;
  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;


  intermediate_rep* minimized = new intermediate_rep();
  alphabetize_and_minimize(ea, minimized, &ltl_string, gp);
  
  std::cout << "After Minimization" << std::endl;
  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;

  delete ea;

  std::cout << "After deleting the unminimized automaton" << std::endl;
  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;


  std::cout << "Doing it via the IR" << std::endl;
  out_strm.open(gp->get_output_file(), std::ios::out);

  if (! out_strm ) {
    std::cerr << "Unable to open " << gp->get_output_file() << " for output." << std::endl;
    exit (1);
  }
  
  std::cout << "Outputting to " << gp->get_output_file() << std::endl;

  out_strm << "#include <systemc>" << std::endl << std::endl;
  out_strm << "// Files to be included by the user's request" << std::endl;
  gp->includefiles_to_stream(out_strm);
  out_strm << std::endl << std::endl;
  
  svector_t ap_vector;
  get_ap_vector(&ltl_string, &ap_vector);
  ir2bsm(minimized, gp, mp, out_strm, &ap_vector);
  
  //ir2bnm(minimized, gp, mp, out_strm);
  
  automaton_tools::generate_local_observer(out_strm, gp);
  out_strm.close();
  
  delete minimized;
  std::cout << "After deleting the minimized automaton" << std::endl;
  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;

  exit(0);

  
  v_sbmap_t ta;
  form2assgnmts(&ltl_string, &ta);
  //test_assignments(ltl_string);

  out_strm.open("before_alpha.txt", std::ios::out);
  ir2lbt(ea, out_strm);
  out_strm.close();
  
  ea->alphabetize(&ta);

  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;

  out_strm.open("to_brics.txt", std::ios::out);
  ir2lbt(ea, out_strm);
  out_strm.close();

  delete ea;
  
  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;

  //exit(0);
  
  std::cout << "About to create a new intermediate_rep object " << std::endl;
  ea = new intermediate_rep();

  std::cout << "About to parse the automaton from the file " << std::endl;
  ea->parse_automaton("/projects/vardi/src/automaton-1.11/src/dk/brics/extra/minimized.txt", &ta);
  //ea->to_stream(std::cout);

  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;

  delete ea;

  std::cout << "Number of states: " << state_t::unfreed_states() << std::endl;
  std::cout << "Number of transitions: " << transition_t::unfreed_transitions() << std::endl;
}
