#include "lbt_parser.h"
#include <iostream>
#include <assert.h>
#include "utils.h"

using namespace std;

int main(int argc, char** args) {
  
  char* output_file = "/tmp/automaton.lbt";

  std::ofstream* out_stream = open_for_output(output_file);

  *out_stream << "1 1" << endl;
  *out_stream << "0 1 0 -1" << endl; // initial, accepting
  *out_stream << "0 2" << endl;
  *out_stream << "0 3" << endl;
  *out_stream << "0 1" << endl;
  *out_stream << "-1" << endl;
  close_file(out_stream);

  lbt_parser* parser = new lbt_parser();
  int** transition_table = parser->parse_to_table(output_file, 4);

  assert(transition_table[0][2] == 0);
  assert(transition_table[0][3] == 0);
  assert(transition_table[0][1] == 0);

  out_stream = open_for_output(output_file);
  *out_stream << "2 1" << endl;
  *out_stream << "0 1 0 -1" << endl; // initial, accepting
  *out_stream << "0 2" << endl;
  *out_stream << "0 3" << endl;
  *out_stream << "0 1" << endl;
  *out_stream << "-1" << endl;
  close_file(out_stream);
  
  transition_table = parser->parse_to_table(output_file, 4);
  assert(transition_table[0][2] == 0);
  assert(transition_table[0][3] == 0);
  assert(transition_table[0][1] == 0);
  assert(transition_table[1][2] == -1);
  assert(transition_table[1][3] == -1);
  assert(transition_table[1][1] == -1);
  

  out_stream = open_for_output(output_file);
  *out_stream << "2 1" << endl;
  *out_stream << "0 1 0 -1" << endl; // initial, accepting
  *out_stream << "0 2" << endl;
  *out_stream << "0 3" << endl;
  *out_stream << "0 1" << endl;
  *out_stream << "-1" << endl;
  *out_stream << "1 1 0 -1" << endl; // initial, accepting
  *out_stream << "-1" << endl;
  close_file(out_stream);
  
  transition_table = parser->parse_to_table(output_file, 4);
  assert(transition_table[0][2] == 0);
  assert(transition_table[0][3] == 0);
  assert(transition_table[0][1] == 0);
  assert(transition_table[1][2] == -1);
  assert(transition_table[1][3] == -1);
  assert(transition_table[1][1] == -1);

  
  // New test
  out_stream = open_for_output(output_file);
  *out_stream << "2 1" << endl;
  *out_stream << "0 1 0 -1" << endl; // initial, accepting
  *out_stream << "0 2" << endl;
  *out_stream << "0 3" << endl;
  *out_stream << "0 1" << endl;
  *out_stream << "-1" << endl;
  *out_stream << "1 1 -1" << endl; // initial, accepting
  *out_stream << "1 0" << endl;
  *out_stream << "-1" << endl;
  close_file(out_stream);
  
  transition_table = parser->parse_to_table(output_file, 4);
  assert(transition_table[0][2] == 0);
  assert(transition_table[0][3] == 0);
  assert(transition_table[0][1] == 0);
  assert(transition_table[1][0] == 1);
  assert(transition_table[1][3] == -1);
  assert(transition_table[1][1] == -1);
  


  // New test
  out_stream = open_for_output(output_file);
  *out_stream << "1 1" << endl;
  *out_stream << "0 1 0 -1" << endl; // initial, accepting
  *out_stream << "-1" << endl;
  close_file(out_stream);
  
  transition_table = parser->parse_to_table(output_file, 1);
  assert(transition_table[0][0] == -1);
  assert(transition_table[0][1] == -1);
}
