#include "ksat.h"

extern "C" {

int FormulaNodeCompare(const char *a, const char *b)
{
  Formula *f1, *f2;
  f1=(Formula *)(void*)a;
  f2=(Formula *)(void*)b;
  if (f1->opMain==f2->opMain)
    switch (f1->opMain) {
    case OP_TOP:
    case OP_BOTTOM:
      return 0;
    case OP_PROP:
      if (f1->iSubscript==f2->iSubscript)
	return 0;
      else
	return 1;
    case OP_NOT:
    case OP_DIAMOND:
    case OP_BOX:
      if (f1->pfLeft==f2->pfLeft)
	return 0;
      else
	return 1;
    case OP_AND:
    case OP_OR:
      if ((f1->pfLeft==f2->pfLeft)&&(f1->pfRight==f2->pfRight)) {
      if ((f1->bNegLeft==f2->bNegLeft)&&(f1->bNegRight==f2->bNegRight)&&(f1->iSubscript==f2->iSubscript))
	return 0;
      else
	return 1;
      } else if ((f1->pfLeft==f2->pfRight)&&(f1->pfRight==f2->pfLeft)) {
	cout<<"%";
	if ((f1->bNegLeft==f2->bNegRight)&&(f1->bNegRight==f2->bNegLeft)&&(f1->iSubscript==f2->iSubscript))
	  return 0;
	else
	  return 1;
      } else
	return 1;
    default:
      return 1;
    }
  else
    return 1;
}

int FormulaNodeHash(char *a, int size)
{
  Formula *f=(Formula *)(void *)a;
  int i,j,k;
  i=(int)f->pfLeft;
  j=(int)f->pfRight;
  i=i>>3;
  j=j>>3;
  k=(i+j)&0xffffff;
  k=k+f->iSubscript;
  k=k*f->opMain;
  k=k<<2;
  if (f->bNegLeft)
    k=k|1;
  if (f->bNegRight)
    k=k|2;
  return k%size;
}

st_retval FormulaClearTable(char *key, char *rec, char *arg)
{
  Formula *f=(Formula *)(void *)key;
  f->iRefCount--;
  assert(f->iRefCount>=0);
  if (f->iRefCount==0)
    delete f;
  return ST_CONTINUE;
}

};

/**
Convert the tree into a DAG.
**/

void ConvertToDAG::operator()(Formula *form, Options &opt)
{
  assert(opt.CurrentPhase==PREPROCESSED);
  assert(form!=NULL);
  assert(form->Valid());
  // Snapping child pointers
  switch (form->opMain) {
  case OP_AND:
  case OP_OR:
    assert(form->pfRight!=NULL);
    assert(form->pfRight->Valid());
    while (form->pfRight->opMain==OP_SNAP) {
      assert(form->pfRight->pfLeft!=NULL);
      assert(form->pfRight->pfLeft->Valid());
      form->SetRightChild(form->pfRight->pfLeft);
    }
    // FALLTHRU
  case OP_NOT:
  case OP_DIAMOND:
  case OP_BOX:
    assert(form->pfLeft!=NULL);
    assert(form->pfLeft->Valid());
    while (form->pfLeft->opMain==OP_SNAP) {
      assert(form->pfLeft->pfLeft!=NULL);
      assert(form->pfLeft->pfLeft->Valid());
      form->SetLeftChild(form->pfLeft->pfLeft);
    }
    break;
  }
  assert(form->Valid());
  // Canonize node by ensuring leftptr<rightptr
  if ((form->opMain==OP_AND)||(form->opMain==OP_OR)) {
    Formula *temp;
    if ((int)(void *)form->pfLeft>(int)(void *)form->pfRight) {
      temp=form->pfLeft;
      form->pfLeft=form->pfRight;
      form->pfRight=temp;
    }
    // Optimization by skipping top/bot codes
    if (((form->opMain==OP_AND)&&(form->pfLeft->opMain==OP_TOP))||((form->opMain==OP_OR)&&(form->pfLeft->opMain==OP_BOTTOM))) {
      form->SetLeftChild(form->pfRight);
      form->SetRightChild(NULL);
      form->opMain=OP_SNAP;
    }
    if (((form->opMain==OP_AND)&&(form->pfRight->opMain==OP_TOP))||((form->opMain==OP_OR)&&(form->pfRight->opMain==OP_BOTTOM))) {
      form->SetRightChild(NULL);
      form->opMain=OP_SNAP;
    }
    if (((form->opMain==OP_OR)&&(form->pfLeft->opMain==OP_TOP))||((form->opMain==OP_AND)&&(form->pfLeft->opMain==OP_BOTTOM))) {
      form->SetRightChild(NULL);
      form->opMain=OP_SNAP;
    }
    if (((form->opMain==OP_OR)&&(form->pfRight->opMain==OP_TOP))||((form->opMain==OP_AND)&&(form->pfRight->opMain==OP_BOTTOM))) {
      form->SetLeftChild(form->pfRight);
      form->SetRightChild(NULL);
      form->opMain=OP_SNAP;
    }
  }
  if (form->opMain==OP_SNAP)
    return;
  // Lookup Node in hash table
  char *lookup=NULL;
  int lookupFound;
  
  assert(form->Valid());

  lookupFound=st_lookup(Table, (char *)(void *)form, &lookup);
  if (lookupFound==1) {
    //    cout<<"asked:"<<*(Formula *)form<<" "<<"found:"<<*(Formula*)lookup<<endl;
    form->opMain=OP_SNAP;
    form->SetLeftChild((Formula *)(void *)lookup);
    assert(form->pfLeft->Valid());
    form->SetRightChild(NULL);
  } else {
    form->iRefCount++;
    assert(form->opMain!=OP_SNAP);
    assert(form->Valid());
    st_insert(Table, (char *)((void *)form), (char *)((void *)form));
  }
}

ConvertToDAG::~ConvertToDAG()
{
  st_foreach(Table, FormulaClearTable, NULL);
  st_free_table(Table);
}
