#include "ksat.h"

#include <stdio.h>

#include <algorithm>

extern "C" double bdd_zero_ratio(DdManager *dd, DdNode *P);

//vector<BDD> bddlog;

/**
Interface to parser code.
Reads a formula in the file FileName into member formula using the selected parser(ALC/LWB/TPTP) (Only TPTP/LWB implemented).
**/

void PrintBDD(BDD &b)
{
  BDDvector v(1,&ddManager);
  v[0]=b;
  v.DumpDDcal();
}

extern FILE *lwbin, *tptpin;

void KSATChecker::ReadFormula(string FileName)
{
  // Read file here
  switch (opt.inputFormat) {
  case LWB:
    lwbin=fopen(FileName.c_str(), "r");
    if ((lwbin!=NULL)&&(~ferror(lwbin))) {
      lwbparse();
      formula=(Formula *)parser_formula;
      formula->iRefCount++;
    }
    break;
  case TPTP:
    tptpin=fopen(FileName.c_str(), "r");
    if ((tptpin!=NULL)&&(~ferror(tptpin))) {
      tptpparse();
      formula=(Formula *)parser_formula;
      formula->iRefCount++;
    }
    break;
  }
  
  if (strstr(opt.debugDump,"R1")) {
    cout<<"R1:Read"<<*formula<<endl;
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs read formula"<<endl;
  opt.CurrentPhase=FILE_READ;
}

/**
Convert the formula tree into a form used by the checker.
The formula is normalized, converted to a dag from a tree and the size of the dag is counted.
**/

void KSATChecker::PreProcessFormula()
{
  ConvertDiamondToBox step1;
  ConvertToNormalForm step2;
  ConvertToDAG step3;
  SnapBNFNegEdges step4;
  GetSize step5;

  assert(opt.CurrentPhase==FILE_READ);
  if (!opt.Particles) {// Convert Diamonds to Boxes
    formula->Traverse(step1, opt, true);
    formula->Clear();
    if (strstr(opt.debugDump,"P1")) {
      cout<<"P1:DiaToBox"<<*formula<<endl;
    }
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs dia2box"<<endl;
  formula->Traverse(step2, opt, true);
  formula->Clear();
  
  if (strstr(opt.debugDump,"P2")) {
    cout<<"P2:Normalize"<<*formula<<endl;
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs normalize"<<endl;
  opt.CurrentPhase=PREPROCESSED;
  formula->Traverse(step3, opt);
  formula->Clear();
  if (strstr(opt.debugDump,"P3")) {
    cout<<"P3:DAG"<<*formula<<endl;
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs dag"<<endl;
  if (!opt.Particles) {
    formula->Traverse(step4, opt, true);
    formula->Clear();
    if (strstr(opt.debugDump,"P4")) {
      cout<<"P4:BNFNegEdges"<<*formula<<endl;
    }
  }

  bool formulaNegated = false;
  
  while (formula->opMain==OP_SNAP) {
    Formula *temp;
    if (formula->bNegLeft) {
      formulaNegated = (formulaNegated?false:true);
    }
    temp=formula->pfLeft;
    temp->iRefCount++;
    delete formula;
    formula=temp;
  }
  formula->bNegated = formulaNegated;
  
  formula->Traverse(step5, opt);
  formula->Clear();
  
  int vars=0;
  
  AssignAlternateVarOrdering(formula, vars, opt);
  formula->Clear();

  /*  if (opt.HyperGraphBasedVariableOrdering)
    AssignTestVarOrdering(formula, opt);
  */
  if (strstr(opt.debugDump,"P5")) {
    cout<<"P5:GetSize: Size="<<opt.iSize<<" BDD Vars="<<opt.iBDDVars<<endl;
  }
  
  for (int i=0;i<opt.iBDDVars;i++) {
    ddManager.bddNewVarAtLevel(i);
  }

  //  ddManager.info();

  cout<<Support.TotalTime.Read()/1000.<<" secs getsize"<<endl;
  iNodes=opt.iSize;
  iBDDVars=opt.iBDDVars;

  
  //assert(vars==iNodes);
  
  // Assign variable Numbering should be done here
  opt.CurrentPhase=NORMALIZED;

  InitGlobals(this);
}

class FormulaCompareNodeLevel {
public:
  bool operator()(Formula *const&a, Formula *const&b) {
    if (a->iLevel<=b->iLevel)
      return true;
    else
      return false;
  }
};

void KSATChecker::BuildClusteredTransitionRelation()
{
  vector<Formula *> NodeList;
  BuildNodeList step1(NodeList);
  FormulaCompareNodeLevel compare;
  int i, j;

  cout<<"dead code check"<<endl;

  formula->Traverse(step1, opt);
  formula->Clear();
  
  for (i=0;i<NodeList.size();i++)
    assert(NodeList[i]->Valid());
  
  stable_sort(NodeList.begin(), NodeList.end(), compare);
  
  for (i=0;i<NodeList.size();i++)
    assert(NodeList[i]->Valid());
  
  //  cout<<"Cluster1:NodeList"<<endl;

  // Start building the clusters
  Support.BoxRelationClustered.resize(1);
  Support.BoxRelationClustered[0]=ddManager.bddOne();
  for (i=NodeList.size()-1; i>=0; i--) {
    if (NodeList[i]->opMain!=OP_BOX)
      continue;
    Support.BoxRelationClustered[0]*=NodeList[i]->bddTrans;
    NodeList[i]->bddTrans=ddManager.bddOne();
    if (ddManager.SharingSize(&(Support.BoxRelationClustered[0]), 1)>opt.iClusterThreshold) {
      Support.BoxRelationClustered.insert(Support.BoxRelationClustered.begin(),ddManager.bddOne());
    }
  }

  //  cout<<"Cluster2:Cluster Built"<<endl;

  // Build the projection vectors
  vector<bool> project;
  BDD currentvar;
  BDD projection;

  Support.BoxRelationClusteredProjection.resize(Support.BoxRelationClustered.size());
  project.resize(NodeList.size());
  
  for (j=0;j<Support.BoxRelationClusteredProjection.size();j++) {
    Support.BoxRelationClusteredProjection[j]=ddManager.bddOne();
  }
  
  for (i=0;i<NodeList.size();i++) {
    project[i]=true;
  }

  for (j=Support.BoxRelationClustered.size()-1;j>=1;j--) {
    projection=ddManager.bddOne();
    for (i=0;i<NodeList.size();i++) {
      currentvar=ddManager.bddVar(NodeList[i]->iVarNextOrder);
      if (!Support.BoxRelationClustered[j].VarIsDependent(currentvar)) {
	project[i]=false;
      }
      if (project[i]) {
	projection*=currentvar;
      }
    }
    Support.BoxRelationClusteredProjection[j-1]=projection;
  }
  j=Support.BoxRelationClustered.size()-1;
  for (i=0;i<NodeList.size();i++) {
    currentvar=ddManager.bddVar(NodeList[i]->iVarNextOrder);
    Support.BoxRelationClusteredProjection[j]*=currentvar;
  }
  cout<<"Clusters="<<Support.BoxRelationClustered.size()<<endl;
}

/**
Check the satisfiability of the formula in dag form.
The witnesses of modal operators are generated, and the admissible state set is generated from the initial state set via iteration.
 **/

bool KSATChecker::CheckSatisfiability()
{
  FindMaxLevel step1;
  GenerateNodeLevel *step2;
  ModalWitness step4(&Support.DiamondOperators);
  BuildRestrictionVector step5;

  bool result;

  assert(opt.CurrentPhase==NORMALIZED);
  cout<<Support.TotalTime.Read()/1000.<<" secs cs started"<<endl;

  SetupProfiling(opt);

  formula->TreeTraverse(step1, opt);
  iMaxLevel=formula->iLevel+1;
  if (strstr(opt.debugDump,"C1")) {
    cout<<"C1:FindMaxLevel: Max Level="<<iMaxLevel<<endl;
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs max level"<<endl;

  formula->iLevel=0;
  step2=new GenerateNodeLevel(&(Support.NodeLevel), iNodes, iMaxLevel);
  formula->TreeTraverse(*step2, opt, true, true);
  delete step2;
  if (strstr(opt.debugDump,"C2")) {
    cout<<"C2:GenerateNodeLevel"<<endl;
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs node level"<<endl;

  if (opt.Test) {
    AssignLevelVarOrdering(formula, *this);
    DumpVarOrder(*this, formula, opt);
    LoadVO(*this);
  }


  {
    // Moved from projection vector part since useful for a lot of stuff
    // Now as a member variable in KSATChecker
    BuildNodeList step6c(NodeList);
    formula->Traverse(step6c, opt);
    formula->Clear();
  }

  // Need to reassign var order here.
  /*  if (opt.Test)
    AssignLevelVarOrdering(formula, *this);
  */
  if (opt.DynamicVariableReordering) {
    cout<<"Dynamic variable reordering enabled."<<endl;
    ddManager.AutodynEnable(CUDD_REORDER_SIFT);
    ddManager.EnableReorderingReporting();
    ddManager.SetSiftMaxVar(iBDDVars/Support.NodeLevel[0].size());
    cout<<"Vars="<<iBDDVars<<endl;
    if (opt.Log) {
      for (int i=0;i<iBDDVars/2;i++) {
	ddManager.MakeTreeNode(i*2, 2, MTR_FIXED);
      }
    }
  }

  {
    // This was originally step3.
    LevelBasedInitial.resize(iMaxLevel);
    for (int i=0;i<iMaxLevel;i++) {
      BDD work;
      work=ddManager.bddOne();
      LevelBasedInitial[i]=work;
    }    

    InitialStateSetConstraint step3(Support.NodeLevel, LevelBasedInitial, iMaxLevel);

    formula->Traverse(step3, opt);
    //    if (!opt.UseLevelBasedInitialConstraint)
    // These are not used, just make sure all BDD objects point to legal BDDs just in case
    Initial=StateSet=formula->bddCache;
    // else
    //Initial=StateSet=LevelBasedInitial[iMaxLevel-1];
    formula->Clear();
    cout<<"Initial="<<ddManager.SharingSize(&StateSet, 1)<<" Nodes"<<endl;
    if (strstr(opt.debugDump,"C2")) {

      cout<<"C3:InitialState"<<endl;
    }
  }

  cout<<Support.TotalTime.Read()/1000.<<" secs init state"<<endl;

  {
    Formula work;
    work.opMain=OP_DIAMOND;
    work.SetLeftChild(formula);
    work.iRefCount++;
    work.iIndex=0xffffff;

    // If early clearing of bdd cache is used, tree traversal is needed
    work.Traverse(step4, opt);
    if (opt.Particles)
      SentenceWitness=work.bddWitness;
    else
      SentenceWitness=!work.bddWitness;
    work.Clear();

    if ((opt.Particles==false)&&(formula->bNegated)) {
      SentenceWitness=!SentenceWitness;
    }
    if (strstr(opt.debugDump,"C4")) {    
      cout<<"C4:ModalWitness"<<endl;
    }
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs modal witness"<<endl;

  /*
  // begin ugly
  if (opt.Test) {
    DumpVarOrder(*this, formula, opt);
    //    ddManager.AutodynDisable();
  } else {
    if (opt.Log) {
      DumpVarOrder(*this, formula, opt);
      DumpVO(*this);
    }
  }
  */
  if (0 /*opt.Test*/) {
    //    LoadVO(*this);
    ddManager.AutodynDisable(); 
#if 1
    {
      {
	LevelBasedInitial.resize(iMaxLevel);
	for (int i=0;i<iMaxLevel;i++) {
	  BDD work;
	  work=ddManager.bddOne();
	  LevelBasedInitial[i]=work;
	}    
	
	InitialStateSetConstraint step3(Support.NodeLevel, LevelBasedInitial, iMaxLevel);
	
	formula->Traverse(step3, opt);
	//    if (!opt.UseLevelBasedInitialConstraint)
	Initial=StateSet=formula->bddCache;
	// else
	//Initial=StateSet=LevelBasedInitial[iMaxLevel-1];
	formula->Clear();
	cout<<"Initial="<<ddManager.SharingSize(&StateSet, 1)<<" Nodes"<<endl;
	if (strstr(opt.debugDump,"C2")) {
	  
	  cout<<"C3:InitialState"<<endl;
	}
      }
      cout<<Support.TotalTime.Read()/1000.<<" secs init state#2"<<endl;
      
      {
	Formula work;
	work.opMain=OP_DIAMOND;
	work.SetLeftChild(formula);
	work.iRefCount++;
	work.iIndex=0xffffff;
	
	// If early clearing of bdd cache is used, tree traversal is needed
	work.Traverse(step4, opt);
	if (opt.Particles)
	  SentenceWitness=work.bddWitness;
	else
	  SentenceWitness=!work.bddWitness;
	work.Clear();
	
	if ((opt.Particles==false)&&(formula->bNegated)) {
	  SentenceWitness=!SentenceWitness;
	}
	if (strstr(opt.debugDump,"C4")) {    
	  cout<<"C4:ModalWitness"<<endl;
	}
      }
      cout<<Support.TotalTime.Read()/1000.<<" secs modal witness#2"<<endl;
    }
#endif
  }
  // end ugly  

  if (opt.UseProjection) {
    /*GenerateNodeMinimalModalDepth step5b;
    formula->iLevel=0;
    formula->TreeTraverse(step5b, opt, true);
    formula->Clear();*/
    Support.ProjectionVectorByLevel.resize(iMaxLevel);
    for (int i=0;i<iMaxLevel;i++) {
      Support.ProjectionVectorByLevel[i]=ddManager.bddOne();
    }
    if (!opt.UseLevelBasedEvaluation||!opt.UseLevelBasedInitialConstraint)
      GenerateProjectionVector(formula);
    formula->Clear();
    //    cout<<"C5b:Projection Vector"<<endl;
    cout<<Support.TotalTime.Read()/1000.<<" secs prep"<<endl;
  }

  {
    // First we convert the dag to a vector Q for the clustering algorithm ot use.
    // vector assignment should copy
    vector<Formula *> Q = NodeList;    

    if (opt.MonolithicRelations()) {
       // Not implemented yet. Should not use.
    } else {
      if (opt.UseLevelBasedEvaluation) {
	Support.tr.BuildLevel(*this, opt, Q);
      } else {
	Support.tr.BuildClustered(*this, opt, Q);
      }
    }
  }
  cout<<Support.TotalTime.Read()/1000.<<" secs tr"<<endl;

  /*
  if (opt.Test) {
    // Build Q
    vector<Formula *> Q;
    BuildNodeList step6c(Q);
    formula->Traverse(step6c, opt);
    formula->Clear();
    // Build Q
    Support.tr.BuildLevel(opt, Q, opt.iClusterThreshold, iBDDVars, Support.NodeLevel, Support.ProjectionVectorByLevel);
  } else {
    if (opt.MonolithicRelations()) {
      BuildMonolithicTransitionRelation step6a;
      formula->Traverse(step6a, opt, false);
      formula->Clear();
      Support.BoxRelation=formula->bddTrans;
      formula->bddTrans=ddManager.bddOne();
      
      cout<<"Monolithic transition relation"<<endl;
      //Support.BoxRelation.PrintMinterm();
    } else {
      if (opt.ClusterMethod==Options::LEVELBASED) {
	cout<<"Level Based Cluster"<<endl;
	BuildClusteredTransitionRelation();
      } else {
	// Build Q
	vector<Formula *> Q;
	BuildNodeList step6c(Q);
	formula->Traverse(step6c, opt);
	formula->Clear();
	// Build Q
	cout<<"ILWS"<<endl;
	BuildIWLS95Cluster(opt, Q, Support.BoxRelationClustered, Support.BoxRelationClusteredProjection, opt.iClusterThreshold, iBDDVars, 2.0, 1.0, 1.0, 1.0);
	for (int i=0;i<Support.BoxRelationClustered.size();i++) {
	  cout<<"Testing"<<endl;
	  assert(Support.BoxRelationClustered[i]==Support.tr.TR[i]);
	}
      }
    }
    }*/
  


  ProgramIndicator(IND_MODELBUILT);
  cout<<Support.TotalTime.Read()/1000.<<" secs build model.";
  //ddManager.info();

  if (opt.Log) {
    //    DumpVarOrder(*this, formula, opt);
    DumpVO(*this);
  }
  if (opt.MonolithicRelations())
    cout<<ddManager.SharingSize(&(Support.BoxRelation), 1)<<" Nodes"<<endl;
  else
    cout<<endl;

  if (opt.RestrictionVectorNeeded()) {
    formula->Traverse(step5, opt);
    RestrictionVector = step5.RestrictionVector;
    formula->Clear();
    if (strstr(opt.debugDump,"C5")) {
      cout<<"C5:Restriction"<<endl;
    }
  } else {
    RestrictionVector = ddManager.bddOne();
  }

  /*  if (opt.Test) {
    LoadVO(*this);
    ddManager.AutodynDisable();
    }*/
 
  opt.CurrentPhase=BDDPREPARED;
  // Anything to do here?
  /*
  ddManager.AutodynEnable(CUDD_REORDER_SIFT);
  ddManager.SetSiftMaxVar(1000);
  ddManager.SetSiftMaxSwap(2000000);
  ddManager.SetMaxGrowth(1.2);
  ddManager.SetMinHit(30);
  ddManager.EnableReorderingReporting();
  ddManager.EnableGarbageCollection();
  ddManager.TurnOffCountDead();
  */
  opt.CurrentPhase=ITERATE;
  // Do Iteration
#ifdef USEZDD
  if (!opt.useZDD)
#endif
    result = BDDCheckSatisfiability();
#ifdef USEZDD
  else
    result = ZDDCheckSatisfiability();
#endif
  opt.CurrentPhase=DONE;

  if (opt.Log) {
    //    DumpVarOrder(*this, formula, opt);
    DumpVO(*this);
  }

  return result;
}

/**
Generates the projection vectors for each modal level
**/


/*
void KSATChecker::GenerateProjectionVector(Formula *form)
{
  if (form->mark)
    return;
  form->mark=true;
  if ((form->iLevel>=1)&&(form->NodeUsed(opt)))
    Support.ProjectionVectorByLevel[form->iLevel-1]*=form->GetBDD();
  switch (form->opMain) {
  case OP_NOT:
  case OP_DIAMOND:
  case OP_BOX:
    GenerateProjectionVector(form->pfLeft);
    break;
  case OP_AND:
  case OP_OR:
    GenerateProjectionVector(form->pfLeft);
    GenerateProjectionVector(form->pfRight);
    break;
  } 
}
*/

// An alternate method of projection. Project out all not on current level. Add in initial constraint at current level.
/*
void KSATChecker::GenerateProjectionVector(Formula *form)
{
  if (form->mark)
    return;
  form->mark=true;
  if (form->NodeUsed(opt)) {
    for (int i=0;i<iMaxLevel;i++) {
      if (!Support.OperatorInLevel(form, i))
	Support.ProjectionVectorByLevel[i]*=form->GetBDD();
    }
  }
  cout<<"#"<<flush;
  switch (form->opMain) {
  case OP_NOT:
  case OP_DIAMOND:
  case OP_BOX:
    GenerateProjectionVector(form->pfLeft);
    break;
  case OP_AND:
  case OP_OR:
    GenerateProjectionVector(form->pfLeft);
    GenerateProjectionVector(form->pfRight);
    break;
  } 
  }*/

// A new alternate approach for building projection vector. Hopefully fast.

void KSATChecker::GenerateProjectionVector(Formula *form)
{
  vector<Formula *> Q;
  BuildNodeList step1(Q);
  form->Traverse(step1, opt);
  form->Clear();
  vector<Formula *> F;
  F.resize(Support.NodeLevel.size());
  for (int i=0;i<F.size();i++) {
    F[i]=NULL;
  }
  for (int i=0;i<Q.size();i++) {
    F[Q[i]->iIndex]=Q[i];
  }
  int maxsize=F.size();
  BDD *CubeList=new BDD[maxsize];
  int *Phase=new int[maxsize];
  for (int i=0;i<maxsize;i++) {
    Phase[i]=1;
  }
  int size;
  for (int i=0;i<iMaxLevel;i++) {
    size=0;
    for (int j=0;j<F.size();j++) {
      if (F[j]!=NULL)
	if (!Support.OperatorInLevel(F[j], i))
	  CubeList[size++]=F[j]->GetBDD();
    }
    Support.ProjectionVectorByLevel[i]=ddManager.bddComputeCube(CubeList, Phase, size);
    cout<<"("<<flush;
  }
  delete[] CubeList;
  delete[] Phase;
}

/**
Returns the state subset that witnesses (or not witnesses) the modal operators in one iteration step or one level.
**/

BDD KSATChecker::GetWitness(int level)
{
  BDD work, preimg, img, diamondvar;
  BDD TransitionRelation;
  BDD CurrentWitness;
  if (opt.Test2)
    CurrentWitness=ddManagerReordered.bddOne();
  else
    CurrentWitness=ddManager.bddOne();
  vector<Formula*>::iterator DiamondIterator;
  
  work=StateSet;
  if (!opt.UseCofactor) {
    for (DiamondIterator=Support.DiamondOperators.begin();DiamondIterator!=Support.DiamondOperators.end();DiamondIterator++) {
      assert((*DiamondIterator)->Valid(CHECKSAT));
      assert(((*DiamondIterator)->opMain==OP_DIAMOND)||((*DiamondIterator)->opMain==OP_BOX));
      if (opt.UseLevelBasedEvaluation)
	if (!Support.OperatorInLevel(*DiamondIterator, level))
	  continue;
      if (opt.Particles) {
	diamondvar=~(*DiamondIterator)->GetBDD();
      } else {
	diamondvar=(*DiamondIterator)->GetBDD();	
      }
      if (opt.Test2) {
	diamondvar = diamondvar.Transfer(ddManagerReordered);
      }
      if (opt.Test2) {
	preimg=work*(((*DiamondIterator)->bddWitness).Transfer(ddManagerReordered));
      } else {
	preimg=work*(*DiamondIterator)->bddWitness;
      }
      /*
      cout<<"preimg"<<endl;
      preimg.PrintMinterm();
      */
      
      // New TR clean up
      img = Support.tr.PreImage(preimg,  level);
      
      /*
	if (opt.MonolithicRelations()) {
	TransitionRelation=Support.GetBoxRelation(level, opt);
	if (opt.UseProjection)
	img=ImageBackwardAbstract(TransitionRelation, preimg, Support.GetProjectionVector(level, opt));
	else
	img=ImageBackward(TransitionRelation, preimg);
	} else {
	if (opt.Test) {
	img = Support.tr.PreImage(preimg, level, 0);
	} else 
	if (opt.UseProjection)
	if (opt.UseLevelBasedEvaluation) 
	img=ImageBackwardClusteredAbstract2(Support.BoxRelationClustered, Support.BoxRelationClusteredProjection, preimg, Support.GetProjectionVector(level, opt), Support.GetProjectionVector(level+1, opt));
	else
	img=ImageBackwardClusteredAbstract(Support.BoxRelationClustered, Support.BoxRelationClusteredProjection, preimg, Support.GetProjectionVector(level, opt));
	else
	img=ImageBackwardClustered(Support.BoxRelationClustered, Support.BoxRelationClusteredProjection, preimg);
	}
      */
      
      /*
      cout<<"img"<<endl;
      img.PrintMinterm();
      */
      CurrentWitness*=diamondvar+img;
      preimg=img=ddManager.bddOne();
    }
  } else { // Use cofactor
    // When cofactor is not used, the witnesses are removed from the state set (or added when bottom up NOT DONE)
    assert(!opt.UseLevelBasedEvaluation);
    assert("Not Implemented"!=NULL);
  }
  return CurrentWitness;
}

#ifdef USEZDD
ZDDFunc KSATChecker::GetWitnessZ(int level)
{
  ZDDFunc work, preimg, img, diamondvar;
  ZDDFunc TransitionRelation;
  BDD one = ddManager.bddOne();
  BDD workB;
  ZDDFunc CurrentWitness=ZDDFunc(one);
  vector<Formula*>::iterator DiamondIterator;
  
  work=StateSetZ;
  if (!opt.UseCofactor) {
    for (DiamondIterator=Support.DiamondOperators.begin();DiamondIterator!=Support.DiamondOperators.end();DiamondIterator++) {
      assert((*DiamondIterator)->Valid(CHECKSAT));
      assert(((*DiamondIterator)->opMain==OP_DIAMOND)||((*DiamondIterator)->opMain==OP_BOX));
      if (opt.UseLevelBasedEvaluation)
	if (!Support.OperatorInLevel(*DiamondIterator, level))
	  continue;
      if (opt.Particles) {
	workB = ~(*DiamondIterator)->GetBDD();
      } else {
	workB = (*DiamondIterator)->GetBDD();
      }
      diamondvar=ZDDFunc(workB);
      workB = (*DiamondIterator)->bddWitness;
      preimg=work*ZDDFunc(workB);
      img = Support.tr.PreImage(preimg,  level);
      CurrentWitness = CurrentWitness * (diamondvar+img);
      preimg=img=ZDDFunc(one);
    }
  } else { // Use cofactor
    // When cofactor is not used, the witnesses are removed from the state set (or added when bottom up NOT DONE)
    assert(!opt.UseLevelBasedEvaluation);
    assert("Not Implemented"!=NULL);
  }
  return CurrentWitness;
}
#endif

/**
The iterator function to find the fixpoint of the state set.
**/

void KSATChecker::Iterate(int level)
{
  BDD CurrentWitness;

  Support.IterationTime.Init();
  Support.IterationTime.Start();

  if (opt.Log) {
    //    DumpVarOrder(*this, formula, opt);
    DumpVO(*this);
  }

  if (opt.TopDown) {
    /*
    cout<<"State Set "<<level<<endl;
    StateSet.PrintMinterm();
    */
    CurrentWitness=GetWitness(level);
    //    cout<<Support.IterationTime.Read()/1000.<<" secs ";
    /*
    cout<<"Current Witness "<<level<<endl;
    CurrentWitness.PrintMinterm();
    */
    if (opt.UseProjection) 
      NextStateSet=CurrentWitness;
    else
      NextStateSet=StateSet*CurrentWitness;
  } else {
    CurrentWitness=GetWitness(level);
    //    cout<<Support.IterationTime.Read()/1000.<<" secs ";
    if (opt.UseProjection)
      NextStateSet=CurrentWitness;
    else
      NextStateSet=(StateSet+CurrentWitness)*RestrictionVector;
    
  }
  //  cout<<Support.IterationTime.Read()/1000.<<" secs ";

  if (opt.UseProjection) {
    if (!opt.UseLevelBasedInitialConstraint) {
      NextStateSet=NextStateSet.AndAbstract(Initial, Support.GetProjectionVector(level, opt));
      NextStateSet=NextStateSet.AndAbstract(RestrictionVector, Support.GetProjectionVector(level, opt));
      cout<<ddManager.SharingSize(&NextStateSet,1)<<flush;
    } else {
      cout<<ddManager.SharingSize(&NextStateSet,1)<<"x"<<ddManager.SharingSize(&(LevelBasedInitial[level]),1)<<" "<<flush;
      //      cout<<"("<<ZDDFunc(NextStateSet).size()<<"x"<<ZDDFunc(LevelBasedInitial[level]).size()<<")"<<flush;
      NextStateSet=NextStateSet.AndAbstract(LevelBasedInitial[level], Support.GetProjectionVector(level, opt));
    }
  } else {
      cout<<ddManager.SharingSize(&NextStateSet,1)<<flush;
  }
  Support.IterationTime.Stop();
  //  cout<<Support.IterationTime.Read()/1000.<<" secs ";
  //  cout<<ddManager.SharingSize(&NextStateSet,1)<<"States."<<endl;
}

#ifdef USEZDD
void KSATChecker::IterateZ(int level)
{
  ZDDFunc CurrentWitness;

  Support.IterationTime.Init();
  Support.IterationTime.Start();

  if (opt.TopDown) {
    CurrentWitness=GetWitnessZ(level);
    if (opt.UseProjection) 
      NextStateSetZ=CurrentWitness;
    else
      NextStateSetZ=StateSetZ*CurrentWitness;
  } else {
    CurrentWitness=GetWitnessZ(level);
    if (opt.UseProjection)
      NextStateSetZ=CurrentWitness;
    else
      NextStateSetZ=(StateSetZ+CurrentWitness)*RestrictionVectorZ;
  }
  /*
  if (opt.UseProjection) {
    if (!opt.UseLevelBasedInitialConstraint) {
      NextStateSet=NextStateSet.AndAbstract(Initial, Support.GetProjectionVector(level, opt));
      NextStateSet=NextStateSet.AndAbstract(RestrictionVector, Support.GetProjectionVector(level, opt));
      cout<<ddManager.SharingSize(&NextStateSet,1)<<flush;
    } else {
  */
  cout<<NextStateSetZ.size()<<"x";
  cout<<LevelBasedInitialZ[level].size()<<" "<<flush;
  NextStateSetZ=NextStateSetZ.AndAbstract(LevelBasedInitialZ[level], Support.GetProjectionVectorZ(level, opt));
  /*  }
  } else {
      cout<<ddManager.SharingSize(&NextStateSet,1)<<flush;
  }
  */
  Support.IterationTime.Stop();
}
#endif

/**
Computes the fixpoint of the state set and returns whether the formula is satisfiable.
**/

bool KSATChecker::BDDCheckSatisfiability()
{
  bool result;
  /*
  if (opt.Log) {
    bddlog.push_back(StateSet);
  }
  */
  BDD temp;
  if (opt.UseLevelBasedEvaluation==false) {
    NextStateSet=StateSet;
    do {
      StateSet=NextStateSet;
      ProgramIndicator(IND_ITERATION);
      Iterate(0);
      //      bdd_zero_ratio(NextStateSet.manager()->getManager(), NextStateSet.getNode());
    } while (NextStateSet!=StateSet);
  } else {
    for (int i=iMaxLevel-1; i>=0; i--) {
      ProgramIndicator(IND_ITERATION);
      Iterate(i);
      /*
      if (opt.Log) {
	bddlog.push_back(StateSet*NextStateSet);
      }
      */
      StateSet=NextStateSet;       
    }
  }
  
  // Done iteration
  if (opt.Test2) {
    SentenceWitness = SentenceWitness.Transfer(ddManagerReordered);
  }
  temp=StateSet*SentenceWitness;
  cout<<endl<<ddManager.SharingSize(&SentenceWitness, 1)<<" Nodes in witness."<<endl;
  BDD zero;
  if (opt.Test2)
    zero = ddManagerReordered.bddZero();
  else
    zero = ddManager.bddZero();
  if (temp!=zero) {
    cout<<"Sat"<<endl;
    result=true;
  } else {
    cout<<"Unsat"<<endl;
    result=false;
  }
  cout<<ddManager.SharingSize(&StateSet,1)<<" Nodes in state, ";
  if (opt.MonolithicRelations())
    cout<<ddManager.SharingSize(&(Support.BoxRelation), 1)<<" Nodes in TR"<<endl;
  else
    cout<<endl;

  
  return result;
}

#ifdef USEZDD
bool KSATChecker::ZDDCheckSatisfiability()
{
  bool result;

  BDD temp;
  StateSetZ = ZDDFunc(StateSet);
  RestrictionVectorZ = ZDDFunc(RestrictionVector);
  Support.tr.BuildZDD();
  LevelBasedInitialZ.resize(LevelBasedInitial.size());
  for (int i=0;i<LevelBasedInitial.size();i++)
    LevelBasedInitialZ[i] = ZDDFunc(LevelBasedInitial[i]);
  if (opt.UseLevelBasedEvaluation==false) {
    NextStateSetZ=StateSetZ;
    do {
      StateSetZ=NextStateSetZ;
      ProgramIndicator(IND_ITERATION);
      IterateZ(0);
    } while (NextStateSetZ!=StateSetZ);
  } else {
    for (int i=iMaxLevel-1; i>=0; i--) {
      ProgramIndicator(IND_ITERATION);
      IterateZ(i);
      StateSetZ=NextStateSetZ;
    }
  }
  
  // Done iteration
  StateSet = StateSetZ.toBDD();

  temp=StateSet*SentenceWitness;
  if (temp!=ddManager.bddZero()) {
    cout<<"Sat"<<endl;
    result=true;
  } else {
    cout<<"Unsat"<<endl;
    result=false;
  }
  cout<<ddManager.SharingSize(&StateSet,1)<<" Nodes in state, ";
  if (opt.MonolithicRelations())
    cout<<ddManager.SharingSize(&(Support.BoxRelation), 1)<<" Nodes in TR"<<endl;
  else
    cout<<endl;
  return result;
}
#endif

/**
The main method of the KSAT checker.
**/

void KSATChecker::Main(string FileName)
{
  Support.TotalTime.Init();
  Support.IterationTime.Init();
  Support.TotalTime.Start();

  ReadFormula(FileName);
  PreProcessFormula();

  //  SetupProfiling(opt);

  Satisfiable=CheckSatisfiability();
  cout<<Support.TotalTime.Read()/1000.<<" secs total."<<endl;
   
  FILE *f;
  f=fopen("time.dat","a");

  if (Satisfiable) {
    fprintf(f,"%d,%d",1,Support.TotalTime.Read());
  } else {
    fprintf(f,"%d,%d",0,Support.TotalTime.Read());
  }
  fclose(f);
  /*  // Dump running time
  WriteLog();*/
  // BDD Package Info
  //ddManager.info();
  //  bddlog.resize(0);
}



