#ifndef __KSATCHECKER_H
#define __KSATCHECKER_H

#include "ksat.h"
#include <string>

/**
   Debug log 
**/
extern vector<BDD> bddlog;

/**
The main class of the KSAT Checker.
**/

class KSATChecker
{
public:
  /// The formula to be checked.
  Formula *formula;
  /// The parameters for checking.
  Options opt;
  /// Support data for checking.
  KSATSupport Support;
  /// The current state set for iteration.
  BDD StateSet;
#ifdef USEZDD
  ZDDFunc StateSetZ;
#endif
  /// The Initial State Set
  BDD Initial;
#ifdef USEZDD
  ZDDFunc InitialZ;
#endif
  /// For level based initial constraint, a vector of bdds is needed
  vector<BDD> LevelBasedInitial;
#ifdef USEZDD
  vector<ZDDFunc> LevelBasedInitialZ;
#endif
  /// The Witness of the current iteration or modal depth.
  BDD Witness;
  /// The next state set for iteration.
  BDD NextStateSet;
#ifdef USEZDD
  ZDDFunc NextStateSetZ;
#endif
  /// A BDD witness to satisfy the whole sentence.
  BDD SentenceWitness;
  /// A BDD to enforce the restriction the BDD representation of the formula requires.
  BDD RestrictionVector;
#ifdef USEZDD
  ZDDFunc RestrictionVectorZ;
#endif
  /// Whether the formula is satisfiable.
  bool Satisfiable;
  /// The modal depth (+1?) of the formula.
  int iMaxLevel;
  /// The size of the formula.
  int iNodes;
  /// The number of BDD vars used.
  int iBDDVars;
  /// A vector points to all the nodes. Useful to have.
  vector<Formula *> NodeList;
  KSATChecker()
  {
    formula=NULL;
  }
  ~KSATChecker()
  {
    if (formula!=NULL)
      delete formula;
  }
  void ReadFormula(string FileName);
  void PreProcessFormula();
  void BuildClusteredTransitionRelation();
  bool CheckSatisfiability();  
  void GenerateProjectionVector(Formula *form);
  void Iterate(int level);
  void IterateZ(int level);
  BDD GetWitness(int level);
#ifdef USEZDD
  ZDDFunc GetWitnessZ(int level);
#endif
  bool BDDCheckSatisfiability();
#ifdef USEZDD
  bool ZDDCheckSatisfiability();
#endif
  void Main(string FileName);
};

#endif
