#include "ksat.h"

/**
A monolithic backward image function.
**/

BDD ImageBackward(BDD &Transition, BDD &Domain)
{
  BDD work;
  work=Domain.Permute(ImagePermutationVector);
  work=work.AndAbstract(Transition, ImageInputVars);
  return work;
}

BDD ImageBackwardAbstract(BDD &Transition, BDD &Domain, BDD &Abstraction)
{
  BDD work;
  BDD Image=ImageInputVars*Abstraction;
  work=Domain.Permute(ImagePermutationVector);
  work=work.AndAbstract(Transition, Image);
  return work;
}

/**
A monolithic backward image function using cofactor of iteration statesets to reduce bdd size.
**/

BDD ImageBackwardRestrict(BDD &Transition, BDD &Domain, BDD &LastIteration)
{
  BDD work;
  work=Domain.Permute(ImagePermutationVector);
  work=work.AndAbstract(Transition, ImageInputVars);
  return work;
}

BDD ImageBackwardClustered(vector<BDD> &Transition, vector<BDD> &ProjectionVector, BDD &Domain)
{
  BDD work;
  assert(Transition.size()<=ProjectionVector.size());
  //assert(ProjectionVector[Transition.size()-1]==ImageInputVars);
  work=Domain.Permute(ImagePermutationVector);
  for (int i=0;i<Transition.size();i++) {
    work=work.AndAbstract(Transition[i], ProjectionVector[i]);
  }
  return work;
}

BDD ImageBackwardClusteredAbstract(vector<BDD> &Transition, vector<BDD> &ProjectionVector, BDD &Domain, BDD &Abstraction)
{
  BDD work;
  assert(Transition.size()<=ProjectionVector.size());
  //  if (bddlog.size()!=0/*opt.Log*/) {
  //    bddlog.push_back(Domain);
  //  }
  //  assert(ProjectionVector[Transition.size()-1]==ImageInputVars);
  //cout<<"&";
  work=Domain.Permute(ImagePermutationVector);
  for (int i=0;i<Transition.size();i++) {
    //    cout<<"!";
    work=work.AndAbstract(Transition[i], ProjectionVector[i]*Abstraction);
    //    cout<<ddManager.SharingSize(&work, 1)<<flush;
  }
  //  cout<<"@";
  return work;
}

BDD ImageBackwardClusteredAbstract2(vector<BDD> &Transition, vector<BDD> &ProjectionVector, BDD &Domain, BDD &Abstraction, BDD &Abstraction2)
{
  BDD work;
  assert(Transition.size()<=ProjectionVector.size());
  //  assert(ProjectionVector[Transition.size()-1]==ImageInputVars);
  //    cout<<"&"<<flush;
  work=Domain.Permute(ImagePermutationVector);
  BDD a2 = Abstraction2.Permute(ImagePermutationVector);
  //  BDD a = Abstraction * a2;
  for (int i=0;i<Transition.size();i++) {
    //    cout<<"!"<<flush;
    
    BDD t = Transition[i].ExistAbstract(a2);
	
    work=work.AndAbstract(t, ProjectionVector[i] * Abstraction);
    //    cout<<ddManager.SharingSize(&work, 1)<<flush;
  }
  //  cout<<"@"<<flush;
  return work;
}

#ifdef USEZDD

inline void LogSize(ZDDFunc z)
{
  if (sizelog != NULL) {
    BDD b = z.toBDD();
    fprintf(sizelog, "%d, %d\n", z.size(), ddManager.SharingSize(&b, 1));
  }
}

ZDDFunc ImageBackwardClusteredAbstract(vector<ZDDFunc> &Transition, vector<ZDDFunc> &ProjectionVector, ZDDFunc &Domain, ZDDFunc &Abstraction)
{
  ZDDFunc work;
  int i;
  work = Domain.PushForward();

  LogSize(work);

  // ZDDFunc a2 = Abstraction.PushForward();
  for (i=0;i<Transition.size();i++) {
    ZDDFunc Proj;
    if (i!=Transition.size()-1)
      Proj = ProjectionVector[i];
    else
      Proj = Abstraction.CubeProduct(ProjectionVector[i]);
    work = work.AndAbstract(Transition[i], Proj);

    LogSize(work);

    cout<<work.size()<<","<<flush;
  }
  /*  work = work.Exist(Abstraction);
      cout<<work.size()<<"."<<flush;*/
  return work;
}

#endif //USEZDD
