#ifndef __KSATSUPPORT_H
#define __KSATSUPPORT_H

#include "ProfileLogger.h"
#include "ksat.h"
#include <vector>

/**
A class to encapsulate the supporting data of the KSAT checking process.
**/

class KSATSupport {
public:
  /// The modal depth of the formula.
  int Levels;
  // The following four entrys are due for removal affter testing of the tr part.
  /// Box witness relation decomposed by depth.
  vector<BDD> BoxRelationByLevel;
  /// Box witness clustered.
  vector<BDD> BoxRelationClustered;
  /// Incremental projection vector for clustered relations.
  vector<BDD> BoxRelationClusteredProjection;
  /// Box witness relation.
  BDD BoxRelation;

  TransitionRelation tr;

  /// Projection vector for early projection decomposed by modal depth.
  vector<BDD> ProjectionVectorByLevel;
  /// Projection vector for early projection.
  BDD ProjectionVector;
  /// The vector of diamond operators.
  vector<Formula *> DiamondOperators;
  /// The table of occurances of subformulas at modal depth.
  vector<vector<bool> > NodeLevel;
  /// A total running time clock
  StopWatch TotalTime;
  /// A per iteration clock
  StopWatch IterationTime;
  /// Returns whether a node is at a particular modal depth.
  bool OperatorInLevel(Formula * form, int level) {
    return NodeLevel[form->iIndex][level];
  }
  /// Returns the box relation needed for a modal depth.
  BDD &GetBoxRelation(int level, Options &opt) {
    if (opt.MonolithicRelations())
      return BoxRelation;
    else
      return BoxRelationByLevel[level];
  }
  /// Returns the projection vector needed for a modal depth.
  BDD &GetProjectionVector(int level, Options &opt) {
    if (opt.MonolithicProjection())
      return ProjectionVector;
    else
      return ProjectionVectorByLevel[level];
  }
#ifdef USEZDD
  ZDDFunc GetProjectionVectorZ(int level, Options &opt) {
    BDD pj = GetProjectionVector(level, opt);
    ZDDFunc ret = ZDDFunc::MakeCube(pj);
    return ret;
  }
#endif
};

#endif

