#ifndef __OPTIONS_H
#define __OPTIONS_H

enum Phases {INIT, FILE_READ, PREPROCESSED, NORMALIZED, BDDPREPARED, ITERATE, DONE};

enum InputFormat {ALC, LWB, TPTP};

/**
The class to encapsulate the options of the KSAT checker
**/

class Options 
{
public:
  /// True if topdown, false if bottomup.
  bool TopDown;
  /// True if using particles, false if using atoms.
  bool Particles;
  /// True if using lean vectors, false if using full vectors. (Should always use lean vectors)
  bool LeanVectors;
  /// True if dynamic variable reordering turned on.
  bool DynamicVariableReordering;
  /// True if the state set is projected to leave only the variables related to the current level/used in the transition relation before imaging.
  bool UseProjection;
  /// True if only the diamond operators related to the current level is evaluated at a iteration.
  bool UseLevelBasedEvaluation;
  /// True if attempts to use a conjunctively decomposed model.
  bool UseClusteredModel;
  /// The Clustering algorithm used
  enum {LEVELBASED, IWLS95, QR, BQ, EASYBUCKET} ClusterMethod;
  bool InvertedClusters;
  bool InvertedVars;
  /// True if cofactorization is done for imaging to find a smaller state set. (Not for level based evaluation)
  bool UseCofactor;
  /// True if initial state set is constructed in a level based way
  bool UseLevelBasedInitialConstraint;
  /// =0 if timeout disabled, else the seconds before timeout.
  int TimeOut;
  /// True if the dynamic reordering process is adjusted using the bdd size profile.
  /// =0 ig spaceout disabled, else the size of memory allowed before spaceout
  long SpaceOut;
  bool UsebddSizeProfile;
  /// Not used at the moment.
  int InitialVariableOrderingMethod;
  /// Temp var to record the dag size.
  int iSize;
  /// Temp var to record the number of bdd vars.
  int iBDDVars;
  /// Size threshold of each cluster in clustered transition relations.
  int iClusterThreshold;
  /// ZDDs?
  bool useZDD;
  /// Use hypergraph based clustering
  bool HyperGraphBasedTRClustering;
  /// Use hypergraph based variable ordering
  bool HyperGraphBasedVariableOrdering;
  /// Use test option currently coding
  bool Test;
  /// Test option 2
  bool Test2;
  /// Test option 3
  bool Log;

  char debugDump[128];

  double w1, w2, w3, w4;

  /// The format of the input file
  InputFormat inputFormat;
  /// The phase the program is in.
  Phases CurrentPhase;
  Options() 
  {
    TopDown=true;
    Particles=true;
    LeanVectors=true;
    DynamicVariableReordering=true;
    UseProjection=false;
    UseClusteredModel=false;
    ClusterMethod=LEVELBASED;
    UseCofactor=false;
    UseLevelBasedEvaluation=false;
    UseLevelBasedInitialConstraint=false;
    InitialVariableOrderingMethod=0;
    TimeOut=0;
    SpaceOut=0;
    UsebddSizeProfile=false;
    iSize=0;
    iBDDVars=0;
    iClusterThreshold=400;
    CurrentPhase=INIT;
    inputFormat=LWB;
    useZDD = false;
    Test = false;
    Test2 = false;
    Log = false;
    HyperGraphBasedTRClustering = false;
    HyperGraphBasedVariableOrdering = false;
    debugDump[0] = 0;
    w1 = 2.0;
    w2 = w3 = w4 = 1.0;
  }
  bool MonolithicRelations()
  {
    if (!UseClusteredModel)
      return true;
    return false;
  }
  bool MonolithicProjection()
  {
    return false;
  }
  bool RestrictionVectorNeeded()
  {
    return (!(LeanVectors&&Particles)&&!TopDown);
  }
};

#endif
