#include "ksat.h"
#include <sys/time.h>
#include <sys/resource.h>

#ifdef LINUX
#include <bsd/signal.h>
#else // SOLARIS supported
#include <signal.h>
#endif

#include <stdio.h>

#include "cuddInt.h"

static int bddSize[PERF_LOG_MAX];
static int Events[PERF_LOG_MAX];
static int Tick=0;
static int CurrentColor=0;
static bool UseProfileLog=false;

int BDDReorderEnterHook(DdManager *dd, char *str, void *buf)
{
  CurrentColor|=LOG_INREORDER;
  return 1;
}

int BDDReorderExitHook(DdManager *dd, char *str, void *buf)
{
  CurrentColor&=(~LOG_INREORDER);
  return 1;
}

void ProfileSignalHandler(int signal)
{
  Tick++;
  if (Tick<PERF_LOG_MAX) {
    bddSize[Tick]=ddManager.getManager()->keys-ddManager.getManager()->dead;
  }
  return;
}

void TimeoutHandler(int signal)
{
  if (UseProfileLog) {
    WriteLog();
  }
  printf("Timed Out\n");
  FILE *f;
  f=fopen("time.dat", "a");
  fprintf(f, "-1, 999999");
  fclose(f);
  abort();
  return;
}

void SpaceoutHandler(char *s)
{
  if (UseProfileLog) {
    WriteLog();
  }
  printf("Spaced Out\n");
  FILE *f;
  f=fopen("time.dat", "a");
  fprintf(f, "-2, 999999");
  fclose(f);
  abort();
  return;
}


void SetupProfiling(Options &opt)
{
  cout<<"Setup Profiling"<<endl;
  if (opt.TimeOut!=0) {
    struct rlimit rt;
    getrlimit(RLIMIT_CPU, &rt);
    rt.rlim_cur = opt.TimeOut;   
    setrlimit(RLIMIT_CPU, &rt);
    signal(SIGXCPU, TimeoutHandler);

    /*    getrlimit(RLIMIT_DATA, &rt);
    rt.rlim_max = rt.rlim_cur = 20*1024*1024;
    setrlimit(RLIMIT_DATA, &rt);
    signal(SIGSEGV, TimeoutHandler);
    */
    
    if (opt.SpaceOut!=0) {
      ddManager.setHandler(SpaceoutHandler);
      Cudd_SetMaxMemory(ddManager.getManager(), opt.SpaceOut);
    }
    cout<<"Timeout Set"<<endl;
  }
  if (opt.UsebddSizeProfile) {
    struct itimerval timer;
    signal(SIGPROF, ProfileSignalHandler);
    timer.it_interval.tv_sec=0;
    timer.it_interval.tv_usec=10;
    timer.it_value.tv_sec=0;
    timer.it_value.tv_usec=10;
    setitimer(ITIMER_PROF, &timer, NULL);
    ddManager.AddHook(BDDReorderEnterHook, CUDD_PRE_REORDERING_HOOK);
    ddManager.AddHook(BDDReorderExitHook, CUDD_POST_REORDERING_HOOK);
    UseProfileLog=true;
  }
}

void WriteLog()
{
  FILE *f;
  int i;
  f=fopen("bddsize.dat","a");
  for (i=0;i<min(Tick,PERF_LOG_MAX);i++) {
    fprintf(f,"%d %d %d\n",i,bddSize[i], Events[i]);
  }
  fclose(f);
}

void ProgramIndicator(Indicator ind)
{
  switch (ind) {
  case IND_ITERATION:
    cout<<"*"<<flush;
    break;
  case IND_REORDERSTART:
    cout<<"$"<<flush;
    break;
  case IND_REORDEREND:
    cout<<"#"<<flush;
    break;
  case IND_MODELBUILT:
    cout<<"%"<<flush;
    break;
  }
}
