#ifndef __PROFILELOGGER_H
#define __PROFILELOGGER_H

#include "ksat.h"

#define PERF_LOG_MAX 1000000

#define LOG_INBUILD 1
#define LOG_INREORDER 2

enum Indicator {IND_ITERATION, IND_REORDERSTART, IND_REORDEREND, IND_MODELBUILT};

/// Logging function to record the start of reordering.
int BDDReorderEnterHook(DdManager *, char *, void *);
/// Logging function to record the end of reordering.
int BDDReorderExitHook(DdManager *, char *, void *);
extern "C" {
  /// Logging function to profile the nehaviour of the bdd package.
void ProfileSignalHandler(int signal);
  /// Handler for the timeout function.
void TimeoutHandler(int signal);
};
/// Setup the handlers for profiling and log bdd package behaviour.
void SetupProfiling(Options &opt);
/// Writes the profile log to a file.
void WriteLog();
/// Log events the program indicates.
void ProgramIndicator(Indicator ind);

/// A class to log running time of the program.

enum ClockState {RUNNING, STOPPED};

class StopWatch{
  long start;
  long ticks;
  ClockState state;
public:
  StopWatch() {
    start=util_cpu_time();
    ticks=0;
    state=RUNNING;
  }
  void Init() {
    start=util_cpu_time();
    ticks=0;
    state=STOPPED;
  }
  void Start() {
    if (state==STOPPED) {
      start=util_cpu_time();
      state=RUNNING;
    }
  }
  void Stop() {
    if (state==RUNNING) {
      long work=util_cpu_time();
      ticks+=work-start;
      state=STOPPED;
    }
  }
  long Read() {
    if (state==RUNNING) {
      long work=util_cpu_time();
      return ticks+(work-start);
    } else { //STOPPED
      return ticks;
    }
  }
};

#endif
