#include "ksat.h"
#include <algorithm>
#include "cluster.h"

extern "C" double bdd_zero_ratio(DdManager *dd, DdNode *P);

BDD ImageBackwardClusteredAbstractTemp(vector<BDD> &Transition, vector<BDD> &ProjectionVector, BDD &Domain, BDD &Abstraction)
{
  BDD work;
  assert(Transition.size()<=ProjectionVector.size());
  work=Domain.Permute(ImagePermutationVector);

  BDD Proj;

  cout<<"^"<<flush;

  for (int i=0;i<Transition.size();i++) {
    if (i<Transition.size()-1) {
      Proj = ProjectionVector[i];
    }
    else {
      Proj = ProjectionVector[i]*Abstraction;
    }
    work=work.AndAbstract(Transition[i], Proj);

    if (sizelog) {
      int bsize = ddManager.SharingSize(&work, 1);
      ZDD z = work.PortToZdd();
      int zsize = ddManager.SharingSize(&z,1);
      fprintf(sizelog, "%d,%d\n", bsize, zsize);
    }

    cout<<ddManager.SharingSize(&work, 1)<<","<<flush;
  }
  return work;
}

BDD ImageBackwardClusteredAbstractDisjunctiveCluster(vector<BDD> Transition, vector<BDD> ProjectionVector, BDD &Domain, BDD &Abstraction)
{
  vector<BDD> work;
  work.resize(1);
  assert(Transition.size()<=ProjectionVector.size());
  work[0]=Domain.Permute(ImagePermutationVector);
  
  BDD Proj;

  cout<<"^"<<flush;

  for (int i=0;i<Transition.size();i++) {
    if (i<Transition.size()-1) {
      Proj = ProjectionVector[i];
    }
    else {
      Proj = ProjectionVector[i]*Abstraction;
    }
    for (int j=0;j<work.size();j++) {
      work[j]=work[j].AndAbstract(Transition[i], Proj);
    }
    cout<<"%"<<flush;
    for (int j=0;j<work.size();j++) {
      if (ddManager.SharingSize(&work[j], 1) > 20000) {
	// Split j into two halfs;
	BDD a,b;
	BDD v;
	/*a = work[j].SubsetHeavyBranch(2000, 20000);
	b = work[j].Constrain(!a);
	*/
	work[j].VarDisjDecomp(&a, &b);
	//	assert(a+b==work[j]);
	work[j] = a;
	work.push_back(b);
	j--;

	continue;
      }
    }
    cout<<work.size()<<","<<flush;
  }
  BDD w = ddManager.bddZero();
  for (int i=0;i<work.size();i++)
    w+=work[i];
  return w;
}

BDD ImageBackwardClusteredAbstractTemp2(vector<BDD> Transition, vector<BDD> ProjectionVector, BDD &Domain, BDD &Abstraction, int start=0)
{
  BDD work;
  assert(Transition.size()<=ProjectionVector.size());
  if (start == 0)
    work=Domain.Permute(ImagePermutationVector);
  else
    work=Domain;
  
  BDD Proj;

  int Threshold = ddManager.SharingSize(&work,1)*10;

  for (int i=start;i<Transition.size();i++) {
    if (i<Transition.size()-1) {
      Proj = ProjectionVector[i];
    }
    else {
      Proj = ProjectionVector[i]*Abstraction;
    }
    work=work.AndAbstract(Transition[i], Proj);
    int size = ddManager.SharingSize(&work, 1);
    if ((size > Threshold)&&(i!=Transition.size()-1)) {
      Threshold = size/2;
      cout<<start<<"/"<<i<<"."<<flush;
      BDD result = ddManager.bddZero();
      while (size > Threshold) {
	BDD dense = work.SubsetHeavyBranch(2000, Threshold);
	work -= dense;
	//cout<<"{"<<start<<"/"<<i<<":"<<ddManager.SharingSize(&dense, 1)<<"/"<<ddManager.SharingSize(&work, 1)<<"}"<<flush;
	result += ImageBackwardClusteredAbstractTemp2(Transition, ProjectionVector, dense, Abstraction, i+1);
	size = ddManager.SharingSize(&work, 1);
	
      }
      result += ImageBackwardClusteredAbstractTemp2(Transition, ProjectionVector, work, Abstraction, i+1);
      work = result;
      break;
    }
    if (start==0)
      cout<<ddManager.SharingSize(&work, 1)<<","<<flush;
  }
  return work;
}

BDD TransitionRelation::PreImage(BDD &p, int level, int options)
{
    if (type == MONOLITHIC) {
      return ImageBackward(TR[0], p);
    } else if (type == CLUSTERED) { 
      return ImageBackwardClustered(TR, Projection, p);
    } else if (type == CLUSTEREDABSTRACT) {
      return ImageBackwardClusteredAbstractTemp(TR, Projection, p, Abstraction);
      //return ImageBackwardClusteredAbstractDisjunctiveCluster(TR, Projection, p, Abstraction);
    } else if (type == LEVELBASED) {
      return LevelBasedTR[level].PreImage(p, 0, options);
    }
}

void TransitionRelation::Transfer(Cudd &dest)
{
  switch (type) {
  case MONOLITHIC:
  case CLUSTERED:
    break;
  case CLUSTEREDABSTRACT:
    for (int i=0;i<TR.size();i++) {
      TR[i] = TR[i].Transfer(dest);
    }
    for (int i=0;i<Projection.size();i++) {
      Projection[i] = Projection[i].Transfer(dest);
    }
    Abstraction = Abstraction.Transfer(dest);
    break;
  case LEVELBASED:
    for (int i=0;i<LevelBasedTR.size();i++) {
      LevelBasedTR[i].Transfer(dest);
    }
    break;
  }
}

#ifdef USEZDD

ZDDFunc TransitionRelation::PreImage(ZDDFunc &p, int level, int options)
{
 /*   if (type == MONOLITHIC) {
      return ImageBackward(TR[0], p);
    } else if (type == CLUSTERED) { 
      return ImageBackwardClustered(TR, Projection, p);
      } else */
  if (type == CLUSTEREDABSTRACT) {
      return ImageBackwardClusteredAbstract(TRZ, ProjectionZ, p, AbstractionZ);
    } else if (type == LEVELBASED) {
      return LevelBasedTR[level].PreImage(p, 0, options);
    }
}

#endif //USEZDD

void TransitionRelation::BuildLevel(Options &opt, vector<Formula *> &Q, int ClusterThreshold, int BDDVars, vector<vector<bool> > NodeLevel, vector<BDD> LevelProj, double w1, double w2, double w3, double w4)
{
  vector<Formula *> work;
  int MaxLevel = NodeLevel[0].size();
  

  LevelBasedTR.resize(MaxLevel);

  for (int i=0;i<MaxLevel-1;i++) {
    work.resize(0);
    for (int j=0;j<Q.size();j++) {
      if (NodeLevel[Q[j]->iIndex][i]&&(Q[j]->opMain==OP_BOX))
	work.push_back(Q[j]);
    }
    LevelBasedTR[i].BuildClustered(opt, work, ClusterThreshold, BDDVars, w1, w2, w3, w4);
    LevelBasedTR[i].Abstraction = ImageInputVars;

    LevelBasedTR[i].type = CLUSTEREDABSTRACT;
    
  }
  
 for (int i=0;i<Q.size();i++) {
    Q[i]->bddTrans = ddManager.bddOne();
  }
  type = LEVELBASED;
}

void TransitionRelation::BuildLevel(KSATChecker &kc, Options &opt, vector<Formula *>Q)
{
  BuildLevel(opt, Q, opt.iClusterThreshold, kc.iBDDVars, kc.Support.NodeLevel, kc.Support.ProjectionVectorByLevel, opt.w1, opt.w2, opt.w3, opt.w4);
}

void TransitionRelation::BuildClustered(Options &opt, vector<Formula *> &Q, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4)
{
  /*  if (opt.HyperGraphBasedTRClustering)
    BuildHGCluster(opt, Q, TR, Projection, ClusterThreshold, BDDVars, w1, w2, w3, w4);
    else*/
  switch (opt.ClusterMethod) {
  case Options::QR:
    BuildQRCluster(opt, Q, TR, Projection, ClusterThreshold, BDDVars, w1, w2, w3, w4);
    break;
  case Options::BQ:
    BuildBQCluster(opt, Q, TR, Projection, ClusterThreshold, BDDVars, w1, w2, w3, w4);
    break;
  case Options::IWLS95:
    BuildIWLS95Cluster(opt, Q, TR, Projection, ClusterThreshold, BDDVars, w1, w2, w3, w4);
    break;
  }
  type = CLUSTERED;
}

void TransitionRelation::BuildClustered(KSATChecker &kc, Options &opt, vector<Formula *>Q)
{
  BuildClustered(opt, Q, opt.iClusterThreshold, kc.iBDDVars, opt.w1, opt.w2, opt.w3, opt.w4);
}

#ifdef USEZDD
void TransitionRelation::BuildZDD()
{
  if (type == LEVELBASED) {
    for (int i=0;i<LevelBasedTR.size()-1;i++) {
      LevelBasedTR[i].BuildZDD();
    }
  } else {
    TRZ.resize(TR.size());
    ProjectionZ.resize(Projection.size());
    for (int i=0;i<TR.size();i++) {
      TRZ[i] = ZDDFunc(TR[i]);
    }
    for (int i=0;i<Projection.size();i++) {
      ProjectionZ[i] = ZDDFunc::MakeCube(Projection[i]);
    }
    AbstractionZ = ZDDFunc::MakeCube(Abstraction);
  }
}
#endif
