#ifndef __TRANSITIONRELATION_H
#define __TRANSITIONRELATION_H

#include <vector>
#include <set>
#include "cuddObj.hh"

class Formula;
struct Options;

class TransitionRelation {
public:
  enum {MONOLITHIC, CLUSTERED, CLUSTEREDABSTRACT, LEVELBASED} type;
  bool useZDD;
  vector<BDD> TR;
  vector<BDD> Projection;
  
  BDD Abstraction;
  
  vector<TransitionRelation> LevelBasedTR;

  int *Permute;
  
  TransitionRelation() {
    useZDD = false;
  }

  void BuildLevel(KSATChecker &kc, Options &opt, vector<Formula *>Q);
  void BuildClustered(KSATChecker &kc, Options &opt, vector<Formula *>Q);
  BDD PreImage(BDD &p, int level, int options = 0);

  void Transfer(Cudd &dest);

#ifdef USEZDD
  vector<ZDDFunc> TRZ;
  vector<ZDDFunc> ProjectionZ;
  ZDDFunc AbstractionZ;

  ZDDFunc PreImage(ZDDFunc &p, int level, int options = 0);
  void BuildZDD();
#endif //USEZDD

  void BuildMonolithic();
  void BuildClustered(Options &opt, vector<Formula *> &Q, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4);
  void BuildLevel(Options &opt, vector<Formula *> &Q, int ClusterThreshold, int BDDVars, vector<vector< bool> > NodeLevel, vector<BDD> LevelProj, double w1=2.0, double w2=1.0, double w3=1.0, double w4=1.0);

};

#endif

