#include "ksat.h"

#include <set>
#include <vector>
#include <algorithm>
#include <iostream>
#include <fstream>
#include "graph.h"
#include <stdio.h>

#include "cuddInt.h"

extern "C" int bdd_is_var_used(DdManager *dd, DdNode *P, DdNode *var)
{
  DdNode *p, *zero, *pt, *pe, *res;
  int ptop, vtop, retval;
  DdNode *(*cacheOp)(DdManager *, DdNode *, DdNode *);
  
  zero = Cudd_Not(DD_ONE(dd));
  if (Cudd_IsConstant(P))
    return 0;
  p = Cudd_Regular(P);
  if (dd->perm == NULL) {
    ptop = p->index;
    vtop = var->index;
  } else {
    ptop = dd->perm[p->index];
    vtop = dd->perm[var->index];
  }
  if (ptop>vtop)
    return 0;
  cacheOp =
    (DdNode *(*)(DdManager *, DdNode *, DdNode *)) bdd_is_var_used;
  res = cuddCacheLookup2(dd, cacheOp, p, var);
  if (res != NULL)
    return (res != zero);
  if (ptop == vtop) {
    retval = 1;
  } else {
    pt = Cudd_Regular(cuddT(p));
    pe = Cudd_Regular(cuddE(p));
    retval = (bdd_is_var_used(dd, pt, var)||bdd_is_var_used(dd, pe, var));
  }
  cuddCacheInsert2(dd,cacheOp,p,var,Cudd_NotCond(zero,retval));
  
  return(retval);
}

int BDD_IsVarUsed(BDD &p, BDD &var)
{
  return bdd_is_var_used(p.manager()->getManager(), p.getNode(), var.getNode());
}

class ClusteringRange {
public:
  int d;
  int v;
  pair<int, int> range;
  ClusteringRange(int dd=0, int vv=0, int rs=0, int re=0) {
    d = dd;
    v = vv;
    assert(rs<=re);
    range.first = rs;
    range.second = re;
  }
  ClusteringRange(ClusteringRange const& a) {
    d = a.d;
    v = a.v;
    range = a.range;
  }
};

class CRSort{
public:
  int operator()(ClusteringRange const &b, ClusteringRange const &a) {
    // Actually works as > since need to sort to ascending order
    //cout<<"#"<<flush;
    //assert(b.range.first<=b.range.second);
    //assert(a.range.first<=a.range.second);
    if (b.d>a.d)
      return 1;
    if ((b.d==a.d)&&(b.v>=a.v))
      return 1;
    return 0;
  }
};

class BucketSort{
  vector<int> vo;
  vector<pair<BDD, int> > vs;
public:
  BucketSort(vector<int> &ivo, vector<pair<BDD, int> > &s) {
    vo = ivo;
    vs = s;
  }
  int operator()(int i, int j) {
    //    cout<<"["<<i<<","<<j<<"]"<<endl;
    pair<BDD, int> &a=vs[i], &b=vs[j];
    return (a.second<b.second);
    /*    if (a.second.size()==0) return 1;
    if (b.second.size()==0) return 0;
    for (int k=0;k<vo.size();k++) {
            int var = vo[k];
      bool fa=true, fb=false;
      
      bool fa = (a.second.find(var)!=a.second.end());
      bool fb = (b.second.find(var)!=b.second.end());
      if (fa) return 1;
      if (fb) return 0;
      }*/
    return 0;
  }
};

set<int> InputVarsInSupport(Options &opt, Formula *f)
{
  set<int> Vars;
  switch (f->opMain) {
  case OP_PROP:
  case OP_BOX:
  case OP_DIAMOND:
    Vars.insert(f->iVarNextOrder);
    break;
  case OP_NOT:
    Vars=InputVarsInSupport(opt, f->pfLeft);
    if (!opt.LeanVectors)
      Vars.insert(f->iVarNextOrder);
    break;
  case OP_AND:
  case OP_OR:
    Vars=InputVarsInSupport(opt, f->pfLeft);
    set<int> Vars2=InputVarsInSupport(opt, f->pfRight);
    Vars.insert(Vars2.begin(), Vars2.end());
    if (!opt.LeanVectors)
      Vars.insert(f->iVarNextOrder);
   break;
  }
  return Vars;
}

void ConstructProjectionFromCluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection)
{
  vector<bool> project;
  BDD currentvar;
  BDD projection;

  Projection.resize(Cluster.size());
  project.resize(Q.size());
  //  int i,j;
  
  for (int j=0;j<Projection.size();j++) {
    Projection[j]=ddManager.bddOne();
  }
  
  for (int i=0;i<Q.size();i++) {
    project[i]=true;
  }
  
  for (int j=Cluster.size()-1;j>=1;j--) {
    projection=ddManager.bddOne();
    for (int i=0;i<Q.size();i++) {
      currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
      if (BDD_IsVarUsed(Cluster[j], currentvar)){
	project[i]=false;
      }
      if (project[i]) {
	projection*=currentvar;
      }
    }
    Projection[j-1]=projection;
  }
  int j;
  j=Cluster.size()-1;
  for (int i=0;i<Q.size();i++) {
    currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
    Projection[j]*=currentvar;
  }
}

int intsize(set<int> &a, set<int> &b)
{
  set<int> work;
  set_intersection(a.begin(), a.end(), b.begin(), b.end(), inserter(work, work.begin()));
  return work.size();
}

void BuildBQCluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double s2, double w3, double w4)
{
  vector<set<int> > InputVars;
  vector<Formula *> Boxes;

  for (int i=0;i<Q.size();i++) {
    if (Q[i]->opMain == OP_BOX) {
      Boxes.push_back(Q[i]);
      InputVars.push_back(InputVarsInSupport(opt, Q[i]->pfLeft));
    }
  }
  vector<set<int> > vcard;
  vcard.resize(BDDVars);
  //build interference graph
  for (int i=0;i<Boxes.size();i++) {
    set<int> &s = InputVars[i];
    for (set<int>::iterator p=s.begin();p!=s.end();p++) {
      for (set<int>::iterator q=s.begin();q!=s.end();q++) {
	if (*p!=*q) {
	  vcard[*p].insert(*q);
	  vcard[*q].insert(*p);
	}
      }
    }
  }
  set<int> allinputvars;
  for (int i=0;i<InputVars.size();i++) {
    allinputvars.insert(InputVars[i].begin(), InputVars[i].end());
  }
  // sort the variables.
  set<int> allvars = allinputvars;
  vector<int> sortedvars;
  while (allvars.size()>0) {
    int cand = -1;
    int card_size = 0;
    int card_all = 0;
    for (set<int>::iterator p=allvars.begin();p!=allvars.end();p++) {
      set<int> work;
      set_intersection(vcard[*p].begin(), vcard[*p].end(), sortedvars.begin(), sortedvars.end(), inserter(work, work.begin()));
      if (work.size()>card_size) {
	cand = *p;
	card_size = work.size();
	card_all = 0;
      }
      if (work.size() == card_size) {
	if (vcard[*p].size()>card_all) {
	  cand = *p;
	  card_all = vcard[*p].size();
	}
      }
    }
    //    cout<<card_size<<"%"<<flush;
    // chosen max cardinality
    if (cand == -1) {
      for (set<int>::iterator p=allvars.begin();p!=allvars.end();p++) {
	sortedvars.push_back(*p);
      }
      break;
    } else {
      allvars.erase(cand);
      sortedvars.push_back(cand);
    }
  }
  vcard.resize(0);
  //  cout<<"^"<<flush;
  if (opt.InvertedVars) {
    int s = sortedvars.size();
    for (int i=0;i<s/2;i++) {
      swap(sortedvars[i],sortedvars[s-i-1]);
    }
  }
  // Now sortedvars is inverse of max cardinality
  //  cout<<"$"<<flush;
  vector<pair<BDD, int> > sortedbdds;
  vector<int> sortindex;
  cout<<Boxes.size()<<flush;
  for (int i=0;i<Boxes.size();i++) {
    int lv=-1;
    for (int j=0;j<sortedvars.size();j++) {
      if (InputVars[i].find(sortedvars[j])!=InputVars[i].end()) {
	lv = sortedvars.size()-j;
	break;
      }
    }
    sortedbdds.push_back(pair<BDD, int>(Boxes[i]->bddTrans, lv));
    sortindex.push_back(i);
  }
  /*  for (int i=0;i<sortedvars.size();i++) {
    cout<<sortedvars[i]<<" "<<flush;
    }*/
  BucketSort bs(sortedvars, sortedbdds);
  //cout<<"("<<flush;
  sort(sortindex.begin(), sortindex.end(), bs);
  //cout<<"*"<<flush;
  if (opt.InvertedClusters) {
    int s = sortindex.size()/2;
    //cout<<s<<endl;
    for (int i=0;i<s;i++) {
      //cout<<i<<endl;
      swap(sortindex[i],sortindex[sortindex.size()-i-1]);
    }
  }
  //  cout<<"&"<<flush;
  Cluster.push_back(ddManager.bddOne());
  for (int i=0;i<sortedbdds.size();i++) {
    Cluster[Cluster.size()-1] *= sortedbdds[sortindex[i]].first;
    if (ddManager.SharingSize(&Cluster[Cluster.size()-1],1)>ClusterThreshold)
      Cluster.push_back(ddManager.bddOne());
  }
  ConstructProjectionFromCluster(opt, Q, Cluster, Projection);
}

void BuildQRCluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double s2, double w3, double w4)
{
  vector<set<int> > InputVars;
  vector<Formula *> Boxes;
  vector<int> count;

  for (int i=0;i<Q.size();i++) {
    if (Q[i]->opMain == OP_BOX) {
      Boxes.push_back(Q[i]);
      InputVars.push_back(InputVarsInSupport(opt, Q[i]));
    }
  }
  count.resize(BDDVars);
  for (int i=0;i<BDDVars;i++) {
    count[i] = 0;
  }
  for (int i=0;i<InputVars.size();i++) {
    set<int> &s = InputVars[i];
    for (set<int>::iterator p = s.begin();p!=s.end();p++) {
      count[*p]++;
    }
  }
  set<int> twooccurvars;
  set<int> soccurvars;
  for (int i=0;i<BDDVars;i++) {
    if (count[i]==2)
      twooccurvars.insert(i);
    if (count[i]>=2)
      soccurvars.insert(i);
  }

  Cluster.push_back(ddManager.bddOne());
  while (Boxes.size()>0) {
    int index;
    // Choose a formula Boxes[index]
    {
      index = 0;
      int toc = intsize(twooccurvars, InputVars[index]);
      int svc = intsize(soccurvars, InputVars[index]);
      for (int i=1;i<Boxes.size();i++) {
	int toccur = intsize(twooccurvars, InputVars[i]);
	int svccur = intsize(soccurvars, InputVars[i]);
	if ((toccur > toc)||((toccur==toc)&&(svccur<svc))) {
	  toc = toccur;
	  svc = svccur;
	  index = i;
	}
      }
    }

    // Add it to the cluster
    Cluster[Cluster.size()-1] *= Boxes[index]->bddTrans;
    if (ddManager.SharingSize(&Cluster[Cluster.size()-1],1)>ClusterThreshold) {
      Cluster.push_back(ddManager.bddOne());
    }
    // Remove the formula/inputset
    set<int> &s = InputVars[index];
    for (set<int>::iterator p = s.begin();p!=s.end();p++) {
      count[*p]--;
      if (*p==1) {
	twooccurvars.erase(*p);
	soccurvars.erase(*p);
      }
      if (*p==2) {
	twooccurvars.insert(*p);
      }
    }
    InputVars.erase(&s);
    Boxes.erase(&(Boxes[index]));
  }
  ConstructProjectionFromCluster(opt, Q, Cluster, Projection);
}

void BuildIWLS95Cluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4)
{
  vector<int> UsageCount;
  int InputVarCount;
  int InputVarsLeft;
  set<int> QuantifiedCurrentStates;
  vector<int> wC;
  vector<double> weight;
  vector<set<int> > InputVars;
  int MaxBDDIndex;
  int ClusterVectorIndex=0;
  // Setup Cluster
  Cluster.resize(ClusterVectorIndex+1);
  //Projection.resize(ClusterVectorIndex+1);
  Cluster[ClusterVectorIndex]=ddManager.bddOne();
  //Projection[ClusterVectorIndex]=ddManager.bddOne();
  // Find max bdd index
  MaxBDDIndex=BDDVars*2+1;
  // Initialization
  UsageCount.resize(MaxBDDIndex+1);
  InputVars.resize(MaxBDDIndex+1);
  wC.resize(MaxBDDIndex+1);
  for (int i=0;i<=MaxBDDIndex;i++) {
    UsageCount[i]=0;
  }
  
  vector<Formula *> Boxes;
  for (int i=0, j=0;i<Q.size();i++) {
    if (/*(Q[i]->opMain==OP_DIAMOND)||*/(Q[i]->opMain==OP_BOX)) {
      Boxes.push_back(Q[i]);
    }
  }

  // Initialize InputVars and wC
  for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++) {
    int index=(*form)->iVarNextOrder;
    InputVars[index]=InputVarsInSupport(opt, (*form)->pfLeft);
    wC[index]=InputVars[index].size();
    //for (set<int>::iterator p=InputVars[index].begin();p!=InputVars[index].end();p++) {
    //  UsageCount[*p]++;
    //}
  }
  // Initialize UsageCount
  InputVarCount=0;
  for (int i=0;i<UsageCount.size();i++) {
    if (UsageCount[i]!=0)
      InputVarCount++;
    //TO DO:This bug seems to be elsewhere. If it actually ok to di? Effective?
    //else // added 1/2/2002
    // Discovered 1/9/2002
    // This projection is not ok for full vectors!!!
      // added option parameter and do this only for lean
      //if (opt.LeanVectors)
    //if (i%2==1)
    //  Projection[ClusterVectorIndex]*=ddManager.bddVar(i);
  }
  InputVarsLeft=InputVarCount;  
  // Setup weight size
  weight.resize(Boxes.size());
  while (!Boxes.empty()) {
    // Update weight for Boxes
    int i=0;
    int Mc=1;
    for (int j=UsageCount.size()-1;j>=0;j--) {
      if (UsageCount[j]>0) {
	Mc=j;
	break;
      }
    }
    for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++,i++) {
      double rc1, rc2, rc3, rc4;
      int index=(*form)->iVarNextOrder;
      assert(index==((*form)->iVarOrder+1));
      int wc=wC[index];
      int vc=0;
      int mc=0;
      for (set<int>::iterator p=InputVars[index].begin();p!=InputVars[index].end();p++) {
	if (UsageCount[*p]==1) {
	  vc++;
	  mc=max(mc, *p);
	}
      }
      rc1=(double)vc/wc;
      rc2=(double)wc/InputVarsLeft;
      rc3=(double)1/Boxes.size();
      rc4=(double)mc/Mc;
      weight[i]=w1*rc1+w2*rc2+w3*rc3+w4*rc4;
    }
    // Find the transition relation with max weight
    vector<double>::iterator Remove=max_element(weight.begin(), weight.end());
    int RemovePos=Remove-weight.begin();
    Formula *ToBeAdded=Boxes[RemovePos];
    // Add TBA to cluster and Update Date
    int pos=ToBeAdded->iVarNextOrder;
    Cluster[ClusterVectorIndex]*=ToBeAdded->bddTrans;
    //    ToBeAdded->bddTrans=ddManager.bddOne();
    Boxes.erase(Boxes.begin()+RemovePos);
    weight.erase(weight.begin()+RemovePos);
    for (set<int>::iterator p=InputVars[pos].begin();p!=InputVars[pos].end();p++) {
      UsageCount[*p]--;
      if (UsageCount[*p]==0) {
	InputVarsLeft--;
	QuantifiedCurrentStates.insert(*p);
	// Add p to projection
	//Projection[ClusterVectorIndex]*=ddManager.bddVar(*p);
      }
    }
    if (ddManager.SharingSize(&(Cluster[ClusterVectorIndex]),1)>ClusterThreshold) {
      cout<<"%"<<flush;
      ClusterVectorIndex++;
      Cluster.resize(ClusterVectorIndex+1);
      //  Projection.resize(ClusterVectorIndex+1);
      Cluster[ClusterVectorIndex]=ddManager.bddOne();
      //Projection[ClusterVectorIndex]=ddManager.bddOne();
    }
  }

  ConstructProjectionFromCluster(opt, Q, Cluster, Projection);

#if 0

  vector<bool> project;
  BDD currentvar;
  BDD projection;

  Projection.resize(Cluster.size());
  project.resize(Q.size());
  //  int i,j;
  
  for (int j=0;j<Projection.size();j++) {
    Projection[j]=ddManager.bddOne();
  }
  
  for (int i=0;i<Q.size();i++) {
    project[i]=true;
  }
  
  if (!opt.Test) {
  for (int j=Cluster.size()-1;j>=1;j--) {
     projection=ddManager.bddOne();
    for (int i=0;i<Q.size();i++) {
      currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
      if (!Cluster[j].VarIsDependent(currentvar)) {
	project[i]=false;
      }
      if (project[i]) {
	projection*=currentvar;
      }
    }
    Projection[j-1]=projection;
  }
  } else {
  for (int j=Cluster.size()-1;j>=1;j--) {
     projection=ddManager.bddOne();
    for (int i=0;i<BDDVars;i++) {
      currentvar=ddManager.bddVar(i*2+1);
      if (BDD_IsVarUsed(Cluster[j], currentvar)){
	project[i]=false;
      }
      /*
      if (project[i]) {
	projection*=currentvar;
      }
      */
    }
    {
      BDD *vars;
      int *phase;
      int n=0;
      for (int i=0;i<BDDVars;i++) {
	if (project[i]) {
	  n++;
	}
      }
      vars = new BDD[n];
      phase = new int[n];
      for (int i=0, k=0;i<BDDVars;i++) {
	if (project[i]) {
	  vars[k] = ddManager.bddVar(i*2+1);
	  phase[k++] = 1;
	}
      }
      projection = ddManager.bddComputeCube(&vars[0], &phase[0], n);
      delete[] vars;
      delete[] phase;
    }
    Projection[j-1]=projection;
  }
  }
  int j;
  j=Cluster.size()-1;
  for (int i=0;i<Q.size();i++) {
    currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
    Projection[j]*=currentvar;
  }
#endif
  //  cout<<ClusterVectorIndex+1<<" Clusters"<<endl;
}

void BuildClusterFromOrderedTR(vector<BDD> &input, vector<BDD> &output, int threshold, int bddVars)
{
  int size = input.size();
  vector<bool> usage;
  usage.resize(bddVars*input.size());
  cout<<bddVars<<endl;
  // Generare variable usage matrix
  for (int i=0;i<size;i++) {
    BDD work = input[i];
    cout<<"Size="<<ddManager.SharingSize(&work, 1)<<endl;
    //    input[i].PrintMinterm();
    for (int j=0;j<bddVars;j++) {
      BDD var;
      var = ddManager.bddVar(j*2+1);
      int result = BDD_IsVarUsed(work, var);
      if (result) {
	cout<<"#"<<flush;
	usage[i*bddVars+j] = true;
      }
      else {
	cout<<"%"<<flush;
	usage[i*bddVars+j] = false;
      }
    }
  }
  
  vector<int> D, V;
  D.resize(size*size);
  V.resize(size*size);
  // Generate D_i,j for each range.
  for (int i=0;i<size;i++) {
    for (int j=i;j<size;j++) {
      D[i*size+j] = 0;
      V[i*size+j] = 0;
    }
  }
  
  for (int v=0;v<bddVars;v++) {
    int firstOccur, lastOccur;
    firstOccur = size;
    lastOccur = -1;
    for (int i=0;i<size;i++) {
      if (usage[i*bddVars+v]) {
	firstOccur = min(firstOccur, i);
	lastOccur = max(lastOccur, i);
      }
    }
    //    cout<<firstOccur<<" "<<lastOccur<<endl;
    if (firstOccur<=lastOccur) {
      for (int i=0;i<=firstOccur;i++) {
	for (int j=lastOccur;j<size;j++) {
	  assert((0<=i)&&(i<size));
	  assert((0<=j)&&(j<size));
	  D[i*size+j]++;
	}
      }
      for (int i=firstOccur+1;i<lastOccur;i++) {
	bool flag = false;
	for (int j=i;j<size;j++) {
	  assert((0<=i)&&(i<size));
	  assert((0<=j)&&(j<size));
	  if (usage[j*bddVars+v])
	    flag = true;
	  if (flag)
	  V[i*size+j]++;
	}
      }
      for (int j=firstOccur;j<lastOccur;j++) {
	bool flag;
	flag = false;
	for (int i=j;i>=0;i--) {
	  assert((0<=i)&&(i<size));
	  assert((0<=j)&&(j<size));
	  if (usage[i*bddVars+v])
	    flag = true;
	  if (flag)
	    V[i*size+j]++;
	} 
      }
    }
  }
  for (int i=0;i<size;i++) {
    for (int j=0;j<size;j++)
      cout<<D[i*size+j]<<" ";
    cout<<endl;
  }
  // Now create a list of sorted decreasing D_i,j
  vector<ClusteringRange> ML;
  CRSort s;
  ML.resize(0);
  for (int i=0;i<size;i++) {
    for (int j=i;j<size;j++) {
      //      cout<<D[i*size+j]<<" "<<V[i*size+j]<<" "<<i<<" "<<j<<endl;
      ML.push_back(ClusteringRange(D[i*size+j], V[i*size+j], i, j));
    }
  }
  cout<<ML.size()<<" parts"<<endl;
  // Sort!
  for (int i=0;i<ML.size();i++) {
    assert(ML[i].range.first<=ML[i].range.second);
  }
  stable_sort(ML.begin(), ML.end(), s);
  for (int i=0;i<ML.size();i++) {
    assert(ML[i].range.first<=ML[i].range.second);
  }
  // Now start merging clusters
  vector<bool> used;
  used.resize(size);
  for (int i=0;i<size;i++)
    used[i] = false;
  
  for (int i=0;i<ML.size();i++) {
    pair<int, int> range;
    bool notUsed;
    notUsed = false;
    // Get the best condidate into range
    range = ML[i].range;
    for (int j=range.first;j<=range.second;j++) {
      //cout<<range.first<<" "<<range.second<<endl;
      assert(j<size);
      if (used[j]) {
	notUsed = true;
	break;
      }
    }
    if (notUsed)
      continue;
    if (range.first==range.second)
      continue;
    assert(range.first<range.second);
    //    cout<<"Chosen "<<range.first<<" "<<range.second<<endl;
    // Now check size for threshold
    BDD Merged;
    Merged = ddManager.bddOne();
    for (int j=range.first;j<=range.second;j++) {
      assert(j<size);
      Merged *= input[j];
    }
    if (ddManager.SharingSize(&Merged, 1)>=threshold)
      continue;
    // merge
    int j;
    for (j=range.first;j<range.second;j++) {
      assert(j<size);
      input[j] = ddManager.bddOne();
    }
    assert(j==range.second);
    assert(j<size);
    input[j] = Merged;
    // Update used table
    for (j=range.first;j<=range.second;j++) {
      assert(j<size);
      used[j] = true;
    }
  }
  output.resize(0);
  for (int i=0;i<size;i++)
    if (input[i]!=ddManager.bddOne())
      output.push_back(input[i]);
  
}

struct ClusterSort {
  vector<set<int> > &InputVars;
  ClusterSort(vector<set<int> >&iv):InputVars(iv) {
  }
  int operator()(Formula *const &a, Formula *const &b) {
    int amin = *min_element(InputVars[a->iVarNextOrder].begin(), InputVars[a->iVarNextOrder].end());
    int bmin = *min_element(InputVars[b->iVarNextOrder].begin(), InputVars[b->iVarNextOrder].end());
    return (amin<bmin);
  }
};

void BuildOrderedCluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4)
{
  int InputVarCount;
  int InputVarsLeft;
  set<int> QuantifiedCurrentStates;
  vector<int> wC;
  vector<double> weight;
  vector<set<int> > InputVars;
  int MaxBDDIndex;
  int ClusterVectorIndex=0;
  // Setup Cluster
  Cluster.resize(ClusterVectorIndex+1);
  Cluster[ClusterVectorIndex]=ddManager.bddOne();
  // Find max bdd index
  MaxBDDIndex=BDDVars*2+1;
  // Initialization
  InputVars.resize(MaxBDDIndex+1);
  wC.resize(MaxBDDIndex+1);  
  vector<Formula *> Boxes;
  for (int i=0, j=0;i<Q.size();i++) {
    if (/*(Q[i]->opMain==OP_DIAMOND)||*/(Q[i]->opMain==OP_BOX)) {
      Boxes.push_back(Q[i]);
    }
  }
  // Initialize InputVars
  for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++) {
    int index=(*form)->iVarNextOrder;
    InputVars[index]=InputVarsInSupport(opt, *form);
    wC[index]=InputVars[index].size();
  }
  ClusterSort s(InputVars);
  sort(Boxes.begin(), Boxes.end(), s);

  Cluster.resize(0);
  Cluster.push_back(ddManager.bddOne());
  int cur = 0;
  for (int i=0;i<Boxes.size();i++) {
    Cluster[cur] *= Boxes[i]->bddTrans;
    if (ddManager.SharingSize(&(Cluster[cur]),1)>ClusterThreshold) {
      cout<<"%"<<flush;
      cur++;
      Cluster.push_back(ddManager.bddOne());
    }
  }
  ConstructProjectionFromCluster(opt, Q, Cluster, Projection);
  cout<<cur+1<<" Clusters"<<endl;
}

void BuildHGCluster(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4)
{
  //vector<int> UsageCount;
  int InputVarCount;
  int InputVarsLeft;
  //set<int> QuantifiedCurrentStates;
  vector<int> wC;
  vector<set<int> > InputVars;
  vector<Formula *> Boxes;
  int MaxBDDIndex;
  int ClusterVectorIndex=0;
  // Setup Cluster
  Cluster.resize(ClusterVectorIndex+1);
  //Projection.resize(ClusterVectorIndex+1);
  Cluster[ClusterVectorIndex]=ddManager.bddOne();
  //Projection[ClusterVectorIndex]=ddManager.bddOne();
  // Find max bdd index
  MaxBDDIndex=BDDVars*2+1;
  // Initialization
  //UsageCount.resize(MaxBDDIndex+1);
  InputVars.resize(MaxBDDIndex+1);
  for (int i=0;i<=MaxBDDIndex;i++) {
    InputVars[i].clear();
  }
  wC.resize(MaxBDDIndex+1);
  //for (int i=0;i<=MaxBDDIndex;i++) {
  //  UsageCount[i]=0;
  //}
  
  for (int i=0, j=0;i<Q.size();i++) {
    if (/*(Q[i]->opMain==OP_DIAMOND)||*/(Q[i]->opMain==OP_BOX)) {
      Boxes.push_back(Q[i]);
    }
  }

  // Initialize InputVars and wC
  for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++) {
    int index=(*form)->iVarNextOrder;
    InputVars[index]=InputVarsInSupport(opt, *form);
    wC[index]=InputVars[index].size();
    //for (set<int>::iterator p=InputVars[index].begin();p!=InputVars[index].end();p++) {
    //  UsageCount[*p]++;
    //}
  }
  
  HyperGraph gg;
  gg.Vertices = Boxes.size();
  for (int i=0;i<Q.size();i++) {
    vector<int> work;
    work.resize(0);
    for (int j=0;j<Boxes.size();j++) {
      if (InputVars[Boxes[j]->iVarNextOrder].find(i)==InputVars[Boxes[j]->iVarNextOrder].end()) continue;
      work.push_back(i);
    }
    if (work.size()>0)
      gg.addEdge(work);
  }
  {
    /*ofstream os("ord.cnf");
	os<<gg;
    os.close();*/
    gg.outputCAPO();
  }
  //  system("cnf2hgraph.pl ord.cnf >/dev/null");
  //  system("mpt -saveXorder -f out.aux >/dev/null");
  vector<int> result;
  FILE *f;
  f=fopen("left2right.ord","r");
  //  ifstream is("left2right.ord");
  for (int i=0;i<opt.iSize;i++) {
    char c[80];
    fscanf(f, "%s", &c);
    result.push_back(atoi(c+1)-1);
  }
  fclose(f);
  vector<BDD> input;
  input.resize(0);
  for (int i=0;i<Boxes.size();i++) 
    input.push_back(Boxes[result[i]]->bddTrans);
  BuildClusterFromOrderedTR(input, Cluster, ClusterThreshold, BDDVars);
  ConstructProjectionFromCluster(opt, Q, Cluster, Projection);
  
  cout<<Cluster.size()<<" Clusters"<<endl;
}

void BuildIWLS95ClusterOld(Options &opt, vector<Formula *> &Q, vector<BDD> &Cluster, vector<BDD> &Projection, int ClusterThreshold, int BDDVars, double w1, double w2, double w3, double w4)
{
  vector<int> UsageCount;
  int InputVarCount;
  int InputVarsLeft;
  set<int> QuantifiedCurrentStates;
  vector<int> wC;
  vector<double> weight;
  vector<set<int> > InputVars;
  int MaxBDDIndex;
  int ClusterVectorIndex=0;
  // Setup Cluster
  Cluster.resize(ClusterVectorIndex+1);
  //Projection.resize(ClusterVectorIndex+1);
  Cluster[ClusterVectorIndex]=ddManager.bddOne();
  //Projection[ClusterVectorIndex]=ddManager.bddOne();
  // Find max bdd index
  MaxBDDIndex=BDDVars*2+1;
  // Initialization
  UsageCount.resize(MaxBDDIndex+1);
  InputVars.resize(MaxBDDIndex+1);
  wC.resize(MaxBDDIndex+1);
  for (int i=0;i<=MaxBDDIndex;i++) {
    UsageCount[i]=0;
  }
  
  vector<Formula *> Boxes;
  for (int i=0, j=0;i<Q.size();i++) {
    if (/*(Q[i]->opMain==OP_DIAMOND)||*/(Q[i]->opMain==OP_BOX)) {
      Boxes.push_back(Q[i]);
    }
  }

  // Initialize InputVars and wC
  for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++) {
    int index=(*form)->iVarNextOrder;
    InputVars[index]=InputVarsInSupport(opt, *form);
    wC[index]=InputVars[index].size();
    for (set<int>::iterator p=InputVars[index].begin();p!=InputVars[index].end();p++) {
      UsageCount[*p]++;
    }
  }
  // Initialize UsageCount
  InputVarCount=0;
  for (int i=0;i<UsageCount.size();i++) {
    if (UsageCount[i]!=0)
      InputVarCount++;
    //else // added 1/2/2002
      // Discovered 1/9/2002
      // This projection is not ok for full vectors!!!
      // added option parameter and do this only for lean
      //if (opt.LeanVectors)
    //if (i%2==1)
    //  Projection[ClusterVectorIndex]*=ddManager.bddVar(i);
  }
  InputVarsLeft=InputVarCount;  
  // Setup weight size
  weight.resize(Boxes.size());
  while (!Boxes.empty()) {
    // Update weight for Boxes
    int i=0;
    int Mc=1;
    for (int j=UsageCount.size()-1;j>=0;j--) {
      if (UsageCount[j]>0) {
	Mc=j;
	break;
      }
    }
    for (vector<Formula *>::iterator form=Boxes.begin();form!=Boxes.end();form++,i++) {
      double rc1, rc2, rc3, rc4;
      int index=(*form)->iVarNextOrder;
      assert(index==((*form)->iVarOrder+1));
      int wc=wC[index];
      int vc=0;
      int mc=0;
      for (set<int>::iterator p=InputVars[index].begin();p!=InputVars[index].end();p++) {
	if (UsageCount[*p]==1) {
	  vc++;
	  mc=max(mc, *p);
	}
      }
      rc1=(double)vc/wc;
      rc2=(double)wc/InputVarsLeft;
      rc3=(double)1/Boxes.size();
      rc4=(double)mc/Mc;
      weight[i]=w1*rc1+w2*rc2+w3*rc3+w4*rc4;
    }
    // Find the transition relation with max weight
    vector<double>::iterator Remove=max_element(weight.begin(), weight.end());
    int RemovePos=Remove-weight.begin();
    Formula *ToBeAdded=Boxes[RemovePos];
    // Add TBA to cluster and Update Date
    int pos=ToBeAdded->iVarNextOrder;
    Cluster[ClusterVectorIndex]*=ToBeAdded->bddTrans;
    ToBeAdded->bddTrans=ddManager.bddOne();
    Boxes.erase(Boxes.begin()+RemovePos);
    weight.erase(weight.begin()+RemovePos);
    for (set<int>::iterator p=InputVars[pos].begin();p!=InputVars[pos].end();p++) {
      UsageCount[*p]--;
      if (UsageCount[*p]==0) {
	InputVarsLeft--;
	QuantifiedCurrentStates.insert(*p);
	// Add p to projection
	//Projection[ClusterVectorIndex]*=ddManager.bddVar(*p);
      }
    }
    if (ddManager.SharingSize(&(Cluster[ClusterVectorIndex]),1)>ClusterThreshold) {
      cout<<"%"<<flush;
      ClusterVectorIndex++;
      Cluster.resize(ClusterVectorIndex+1);
      //  Projection.resize(ClusterVectorIndex+1);
      Cluster[ClusterVectorIndex]=ddManager.bddOne();
      //Projection[ClusterVectorIndex]=ddManager.bddOne();
    }
  }

  vector<bool> project;
  BDD currentvar;
  BDD projection;

  Projection.resize(Cluster.size());
  project.resize(Q.size());
  int i,j;
  
  for (j=0;j<Projection.size();j++) {
    Projection[j]=ddManager.bddOne();
  }
  
  for (i=0;i<Q.size();i++) {
    project[i]=true;
  }
  
  for (j=Cluster.size()-1;j>=1;j--) {
    projection=ddManager.bddOne();
    for (i=0;i<Q.size();i++) {
      currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
      if (!Cluster[j].VarIsDependent(currentvar)) {
	project[i]=false;
      }
      if (project[i]) {
	projection*=currentvar;
      }
    }
    Projection[j-1]=projection;
  }
  j=Cluster.size()-1;
  for (i=0;i<Q.size();i++) {
    currentvar=ddManager.bddVar(Q[i]->iVarNextOrder);
    Projection[j]*=currentvar;
  }

  cout<<ClusterVectorIndex+1<<" Clusters"<<endl;
}


