#ifndef __GLOBALS_H
#define __GLOBALS_H

#include "cuddObj.hh"
#include "Formula.h"
#include <vector>

class KSATChecker;

extern "C" {
};

#define MAX_BDD_VARS 65534

/// The BDD manager used.
extern Cudd ddManager;
extern Cudd ddManagerReordered;
/// The permutation vector for next to current translation in imaging.
extern int ImagePermutationVector[MAX_BDD_VARS];
/// The projection vector for keeping only the current variables.
extern BDD ImageInputVars;

/// The return value of the parser.
extern "C" void *parser_formula;
/// The input file of the parser.
extern "C" FILE *llin;
extern "C" FILE *ttin;

extern "C" FILE *sizelog;

///  Initializes the permutation vector and the code for projecting the current variables.
void InitGlobals(KSATChecker *ksat);
#endif
