#include <vector>
#include <set>
#include <stdio.h>
#include <iostream>
#include <algorithm>
#include <queue>
#include <cmath>
#include "graph.h"
#include "ksat.h"

int graph_bw_estimate(Graph &g, vector<int> &order);

ostream &operator<<(ostream &os, HyperGraph &g)
{
  os<<"p cnf ";
  os<<g.Vertices<<" "<<g.E.size()<<endl;
  for (int i=0;i<g.E.size();i++) {
    for (int j=0;j<g.E[i].size();j++)
      os<<g.E[i][j]+1<<" ";
    os<<"0"<<endl;
  }
  return os;
}

vector<int> Graph::OptimizeMatlab()
{
  // write the adjency matrix
  ofstream os("graph.dat");
  for (int i=0;i<Vertices;i++) {
    for (int j=0;j<Vertices-1;j++) {
      os<<E[i*Vertices+j]<<',';
    }
    os<<E[i*Vertices+Vertices-1]<<endl;
  }
  os.close();
  unsetenv("DISPLAY");
  system("matlab < varorder.m");
  ifstream is("order.dat");
  vector<int> result;
  for (int i=0;i<Vertices;i++) {
    int v;
    is>>v;
    result.push_back(v);
  }
  is.close();/*
  vector<int> r;
  r.resize(Vertices);
  for (int i=0;i<Vertices;i++) {
    r[result[i]] = i;
    }*/
  return result;
}

/*
void BandwidthOptimizer::updateOccur()
{
  minoccur.resize(g->Vertices);
  maxoccur.resize(g->Vertices);
  for (int i=0;i<g->Vertices;i++) {
    minoccur[i] = order[i];
    maxoccur[i] = order[i];
  }
  for (int i=0;i<g->Vertices;i++) {
    for (int j=0;j<g->Edges[i].size();j++) {
      int newpos = order[g->Edges[i][j]];
      minoccur[i] = min(minoccur[i], newpos);
      maxoccur[i] = max(maxoccur[i], newpos);
    }
  }
}
*/

void BandwidthOptimizer::random()
{
  vector<int> temp;
  order.resize(g->Vertices);
  temp.resize(g->Vertices);
  for (int i=0;i<g->Vertices;i++)
    temp[i] = i;
  for (int i=0;i<g->Vertices;i++) {
    int r = lrand48()%g->Vertices;
    while (temp[r]==-1)
      r=(r>=g->Vertices?0:r+1);
    order[i] = temp[r];
  }
  //  updateOccur();
}

void BandwidthOptimizer::init()
{
  order.resize(g->Vertices);
  for (int i=0;i<g->Vertices;i++)
    order[i] = i;
  cout<<graph_bw_estimate(*g, order)<<endl;
  //  updateOccur();
}

/*
bool BandwidthOptimizer::hillClimbStep()
{
  double cur = bandwidth();
  cout<<cur<<endl;
  vector<int> swaps;
  BandwidthOptimizer candidate(g);
  for (int i=0;i<g->Vertices-1;i++) {
    //    cout<<"$"<<flush;
    candidate = *this;
    swap(candidate.order[i], candidate.order[i+1]);
    candidate.updateOccur();
    double bw = candidate.bandwidth();
    if (bw<cur)
      swaps.push_back(i);
  }
  if (swaps.size()==0)
    return false;
  int pos = lrand48()%swaps.size();
  swap(order[swaps[pos]], order[swaps[pos]+1]);
  updateOccur();
  return true;
}

void BandwidthOptimizer::hillClimb()
{
  while (hillClimbStep()) {
    ;
  }
}

double BandwidthOptimizer::bandwidth()
{
  double width = 0.0;
  set<int> active;
  updateOccur();
  for (int i=0;i<g->Vertices;i++) {
    for (int j=0;j<g->Vertices;j++) {
      if (minoccur[j]==i) {
	active.insert(j);
      }
      if (maxoccur[j]==i) {
	active.erase(j);
      }	
    }
    width += active.size();
  }
  return width;
}

void BandwidthOptimizer::optimize()
{
  int i=0;
  set<int> active;
  while (i<g->Vertices) {
    // Choose the next var
    int j=-1;
    int count = -1;
    for (int k=0;k<g->Vertices;k++) {
      if (active.find(k)!=active.end())
	continue;
      set<int> related;
      related.clear();
      related.insert(g->Edges[k].begin(), g->Edges[k].end());
      set<int> r;
      r.clear();
      set_intersection(active.begin(), active.end(), related.begin(), related.end(), inserter(r, r.begin()));
      int s = r.size();
      //cout<<s<<" "<<count<<" ";
      if (s>count) {
	//cout<<"#";
	j = k;
	count = s;
      }
    }
    assert(j!=-1);
    active.insert(j);
    order[i++] = j;
  }
}
*/

int graph_bw_estimate(Graph &g, vector<int> &order)
{
  int cost = 0;
  set<int> active;
  set<int> chosen;
  vector<int> degree = g.degree;
  //  for (int i=0;i<degree.size();i++)
  //    cout<<degree[i]<<" ";
  //  cout<<endl;
  // Cost of the known part
  for (int i=0;i<order.size();i++) {
    int cur = order[i];
    active.insert(cur);
    chosen.insert(cur);
    for (int j=0;j<g.Vertices;j++) {
      if (g.E[cur*g.Vertices+j]) {
	if (chosen.find(j)!=chosen.end()) {
	  degree[j]--;
	  if (degree[j]==0)
	    active.erase(j);
	}
      }
    }
    cost+=(active.size()*active.size());
    //cost+=active.size();
  }
  // cost of the unknown part
  for (int i=0;i<g.Vertices;i++) {
    if (chosen.find(i)==chosen.end()) {
      assert(degree[i]>=0);
      int x = degree[i]/2;
      int y = degree[i]-x;
      int edges = (x*(x+1)/2+y*(y+1)/2);
      cost+=edges*edges;
      //cost+=pow(2,degree[i]/2);
      for (int j=0;j<g.Vertices;j++) {
	if (g.E[i*g.Vertices+j])
	  degree[j]--;
      }
    }
  }
  //  cout<<"C="<<cost<<" "<<flush;
  return cost;
}

void BandwidthOptimizer::greedy()
{
  order.resize(0);
  set<int> choice;
  for (int i=0;i<g->Vertices;i++) {
    choice.insert(i);
  }
  while (order.size()<g->Vertices) {
    int best = -1;
    int bestbw = 0xfffffff;
    for (set<int>::iterator p=choice.begin();p!=choice.end();p++) {
      order.push_back(*p);
      int cost = graph_bw_estimate(*g, order);
      if (cost<bestbw) {
	best = *p;
	bestbw = cost;

      }
      order.pop_back();
    }
    assert(best!=-1);
    choice.erase(best);
    order.push_back(best);
    cout<<best<<" "<<flush;
  }
  assert(order.size()==g->Vertices);
  cout<<graph_bw_estimate(*g, order)<<endl;
  cout<<"Greedy Done "<<g->Vertices<<endl;
  /*  for (int i=0;i<order.size();i++)
    cout<<order[i]<<" ";
    cout<<endl;*/
}

void copy_with_swap(vector<int> &order2, vector<int> &order, int i, int j)
{
  int k;
  order2.resize(order.size());
  for (k=0;k<i;k++) 
    order2[k] = order[k];
  order2[i] = order[j];
  for (k=i+1;k<=j;k++)
    order2[k] = order[k-1];
  for (;k<order.size();k++)
    order2[k] = order[k];
}

void BandwidthOptimizer::greedy2()
{
  order.resize(0);
  for (int i=0;i<g->Vertices;i++) {
    order.push_back(i);
  }
  for (int i=0;i<g->Vertices;i++) {
    int best = -1;
    int bestbw = 0xfffffff;
    for (int j=i+1;j<g->Vertices;j++) {
      vector<int> order2;
      copy_with_swap(order2, order, i, j);
      int cost = graph_bw_estimate(*g, order2);
      if (cost<bestbw) {
	best = j;
	bestbw = cost;
      }
    }
    if (best!=-1) {
      vector<int> ordertemp;
      copy_with_swap(ordertemp, order, i, best);
      order = ordertemp;
      cout<<best<<" "<<flush;
    } else
      cout<<i<<" "<<flush;
  }
  cout<<graph_bw_estimate(*g, order)<<endl;
  cout<<"Greedy Done "<<g->Vertices<<endl;
}

void BandwidthOptimizer::BranchAndBound(vector<int> &partial, vector<int> &best, int &bestbw, set<int> &choice)
{
  cout<<"depth="<<partial.size()<<endl;
  priority_queue<pair<int, int> > c;
  for (set<int>::iterator p=choice.begin();p!=choice.end();p++) {
    partial.push_back(*p);
    int cost = graph_bw_estimate(*g, partial);
    if (cost<bestbw) {
      c.push(pair<int, int>(cost, *p));
    }
    partial.pop_back();
  }
  while (!c.empty()) {
    int i = c.top().second;
    int cost = c.top().first;
    c.pop();
    choice.erase(i);
    partial.push_back(i);
    if (choice.size()==0) {
      // Solution found
      best = partial;
      bestbw = cost;
      cout<<"Found "<<cost<<endl;
      return;
    } else
      BranchAndBound(partial, best, bestbw, choice);
    choice.insert(i);
    partial.pop_back();
  }
}

vector<int> BandwidthOptimizer::BranchAndBound()
{
  cout<<"Branching"<<endl;
  vector<int> ord;
  ord.resize(0);
  vector<int> best = order;
  int cost = graph_bw_estimate(*g, order);
  set<int> choice;
  for (int i=0;i<g->Vertices;i++) {
    choice.insert(i);
  }
  BranchAndBound(ord, best, cost, choice);
  cout<<graph_bw_estimate(*g, best)<<endl;
  return best;
}
/*
vector<int> FindMinimumBandwidth(Graph & g, int restarts = 100)
{
  // Hill climbing w/ restarts
  BandwidthOptimizer best(&g);
  BandwidthOptimizer current(&g);
  best.random();
  for (int i=0;i<restarts;i++) {
    current.random();
    current.hillClimb();
    if (current.bandwidth()<best.bandwidth())
      best = current;
  }
  return best.getOrder();
}
*/

