#ifndef __GRAPH_H
#define __GRAPH_H

using namespace std;

#include <iostream>
#include <fstream>
#include <vector>
#include <set>
#include <hash_set>
#include <stdio.h>

class HyperGraph;
ostream &operator<<(ostream &os, HyperGraph &g);

class HyperGraph {
public:
  int Vertices;
  vector<vector<int> > E;
  HyperGraph() {
    Vertices = 0;
    E.resize(0);
  }
  void addEdge(vector<int> e) {
    E.push_back(e);
  }
  void outputCAPO() {
    /*ofstream os("ord.cnf");
    os<<*this;
    os.close();*/
    FILE *f =fopen("ord.cnf", "w");
    fprintf(f, "p cnf %d %d\n",Vertices, E.size());
    for (int i=0;i<E.size();i++) {
      for (int j=0;j<E[i].size();j++)
	fprintf(f, "%d ", E[i][j]+1);
      fprintf(f, "0\n");
    }
    fclose(f);
    system("cnf2hgraph.pl ord.cnf >/dev/null");
    system("mpt -saveXorder -f out.aux >/dev/null");
  }
  vector<int> static readCAPO(int V) {
    vector<int> result;
    FILE *f = fopen("left2right.ord","r");
    for (int i=0;i<V;i++) {
      char c[80];
      fscanf(f, "%s", &c);
      result.push_back(atoi(c+1)-1);
    }
    fclose(f);
    return result;
  }
};

class Graph {
public:
  int Vertices;
  vector<int> E;
  vector<int> degree;
  void setSize(int v) {
    Vertices = v;
    E.resize(v*v);
    for (int i=0;i<E.size();i++) {
      E[i] = 0;
    }
  }
  Graph() {
    Vertices = 0;
    E.resize(0);
  }
  Graph(const Graph &g) {
    Vertices = g.Vertices;
    E.resize(g.E.size());
    for (int i=0;i<g.E.size();i++) {
      E[i]=g.E[i];
    }
  }
  void addEdge(int a, int b) {
    E[a*Vertices+b] = E[b*Vertices+a] = 1;
  }
  void printInfo() {
    cout<<Vertices<<endl;
    for (int i=0;i<Vertices;i++) {
      for (int j=0;j<Vertices;j++)
	if (E[i*Vertices+j])
	  cout<<j<<" ";
      cout<<endl;
    }
  }
  void setDegree() {
    degree.resize(Vertices);
    for (int i=0;i<Vertices;i++) {
      degree[i] = 0;
      for (int j=0;j<Vertices;j++)
	if (E[i*Vertices+j])
	  degree[i]++;
    }
  }
  vector<int> OptimizeMatlab();
};


class BandwidthOptimizer {
  void updateOccur();
public:
  Graph *g;
  vector<int> order;
//  vector<int> minoccur;
  //  vector<int> maxoccur;
  BandwidthOptimizer(Graph *in) {
    g = in;
    cout<<"Set Degree"<<endl;
    g->setDegree();
  }
  BandwidthOptimizer(const BandwidthOptimizer &bo) {
    g = bo.g;
    order = bo.order;
//    minoccur = bo.minoccur;
//    maxoccur = bo.maxoccur;
  }
  void random();
  void init();
//  double bandwidth();
  vector<int> getOrder() {
    return order;
  }
/*  bool hillClimbStep();
  void hillClimb();
  void optimize();
*/
  void greedy();
  void greedy2();
  void BranchAndBound(vector<int> &partial, vector<int> &best, int &bestbw, set<int> &choice);
  vector<int> BranchAndBound();
};

class AbstractVariableRelationGraph {
public:
  void addEdge(int x, int y);
  bool haveEdge(int x, int y);
};

class SmallVariableRelationGraph {
  int *e;
  int v;
public:
  inline SmallVariableRelationGraph(int vars) {
    e = new int[vars*vars];
    v = vars;
    memset(e, 0, sizeof(int)*vars*vars);
  }
  inline ~SmallVariableRelationGraph() {
    delete[] e;
  }
  inline void addEdge(int x, int y) {
    e[x*v+y] = 1;
  }
  inline bool haveEdge(int x, int y) {
    if (x>y)
      return haveEdge(y,x);
    return e[x*v+y];
  }
};

class MediumVariableRelationGraph {
  unsigned int *e;
  int v;
public:
  inline MediumVariableRelationGraph(int vars) {
    e = new unsigned int[vars*vars/sizeof(int)/8];
    v = vars;
    memset(e, 0, vars*vars/8);
  }
  inline ~MediumVariableRelationGraph() {
    delete[] e;
  }
  inline void addEdge(int x, int y) {
    int i = x*v+y;
    int offset = i%32;
    unsigned int z = 1<<offset;
    e[i/32] |= z;
  }
  inline bool haveEdge(int x, int y) {
    if (x>y)
      return haveEdge(y,x);
    int i = x*v+y;
    int offset = i%32;
    return (e[i/32]>>offset)&0x1;
  }
};

#endif

