/*  *********************************************************************** */
/*  *********************************************************************** */

/*  FILE lwb.y - *SAT 1.3 */
/*  Input grammar for the formula file (LWB syntax) */

/*  *********************************************************************** */
/*  *********************************************************************** */

%{

#include "Formula.h"

#define YYMAXDEPTH 1000000

 enum lwb_lexer_symbols {and_code=OP_AND, or_code=OP_OR, not_code=OP_NOT, top_code=OP_TOP, bot_code=OP_BOTTOM, imp_code, iff_code, dia_code=OP_DIAMOND, box_code=OP_BOX};

 extern void *parser_formula;

%}

%union {
   int     l;
   int     i;
   void *f; 
}

/* Tokens */

%token LP RP
%token BOX DIA
%token AND IMP OR IFF NOT
%token TOP BOT
%token ATOM
%token <l> NUM 

%type <f> formula 
%type <f> boolean_expression rule_expression atomic_expression
%type <i> boolop ruleop

%% /* Grammar rules */

input: formula {parser_formula = $1;}
;

formula: boolean_expression {$$ = $1;}
| rule_expression {$$ = $1;}
| atomic_expression {$$ = $1;}
;

boolean_expression: LP formula boolop formula RP {
  if ($3==imp_code) {
    void *temp=build_formula($2, OP_NOT, 0, NULL);
    $$ = build_formula(temp, OP_OR, 0, $4);
  } else if ($3==iff_code) {
    void *temp1, *temp2, *temp3, *temp4, *clone2, *clone3;
    clone2=clone_formula((void *)$2);
    clone3=clone_formula((void *)$4);
    temp1=build_formula(clone2, OP_NOT, 0, NULL);
    temp2=build_formula(clone3, OP_NOT, 0, NULL);
    temp3=build_formula(temp1, OP_OR, 0, $4);
    temp4=build_formula(temp2, OP_OR, 0, $2);
    $$=build_formula(temp3, OP_AND, 0, temp4);
  } else {
    $$ = build_formula($2, $3, 0, $4);
  }
}
| LP NOT formula RP {$$ = build_formula($3, OP_NOT, 0, NULL);}
;

rule_expression: LP ruleop formula RP {
  $$ = build_formula($3, $2, 0, NULL);
}
;

atomic_expression: ATOM NUM {$$ = build_formula(NULL, OP_PROP, $2, NULL);}
| TOP {$$ = build_formula(NULL, OP_TOP, 0, NULL);}
| BOT {$$ = build_formula(NULL, OP_BOTTOM, 0, NULL);}
;

boolop: AND {$$ = and_code;} 
|       IMP {$$ = imp_code;}
|       OR  {$$ = or_code;} 
|       IFF {$$ = iff_code;} 
;

ruleop: DIA {$$ = dia_code;}
| BOX {$$ = box_code;}       

%% /* End of grammar rules */

int yyerror(char *s) 
{
  printf("%s\n", s);
  exit(0);
}
