#include "ksat.h"

void DefaultOptions(Options &opt)
{
  //opt.LeanVectors = false;

    opt.UseLevelBasedEvaluation=true;
    opt.UseProjection=true;
    opt.UseClusteredModel=true;

  opt.DynamicVariableReordering=false;

  opt.iClusterThreshold=500;

  //opt.UsebddSizeProfile=true;

  opt.UseLevelBasedInitialConstraint=true;
  
  opt.TimeOut = 1000;
  opt.SpaceOut = 384*1024*1024;

  opt.Test = opt.Test2 = false;
  opt.ClusterMethod = Options::IWLS95;

  opt.InvertedClusters = false;
  opt.InvertedVars = true;

  //ddManager.SetMaxCacheHard(4000000);
}

int ParseOptions(int argc, char **argv, Options &opt)
{
  int i;
  for (i=1;i<argc;i++) {
    if (strcmp(argv[i],"-t")==0) {
      opt.inputFormat=TPTP;
    } else if (strcmp(argv[i],"-f")==0) {
      opt.LeanVectors = false;
    } else if (strcmp(argv[i], "-base")==0) {
      // Base line testing. No optimizations
      opt.UseLevelBasedEvaluation = false;
      opt.UseProjection = false;
      opt.UseLevelBasedInitialConstraint = false;
    } else if (strcmp(argv[i], "-b")==0) {
      opt.TopDown = false;
    } else if (strcmp(argv[i], "-z")==0) {
      opt.useZDD = true;
      sizelog = NULL;
    } else if (strcmp(argv[i], "-zlog")==0) {
      opt.useZDD = false;
      sizelog = fopen("size.dat","a");
    } else if (strcmp(argv[i], "-a")==0) {
      opt.Particles = false;
    } else if (strcmp(argv[i], "-reorder")==0) {
      opt.DynamicVariableReordering = true;
    } else if (strncmp(argv[i], "-to",3)==0) {
      opt.TimeOut=atoi((const char *)&argv[i][3]);
    } else if (strcmp(argv[i], "-ilws")==0) {
      opt.ClusterMethod = Options::IWLS95;
    } else if (strcmp(argv[i], "-altvo")==0) {
      opt.Test = true;
    } else if (strcmp(argv[i], "-test2")==0) {
      opt.Test2 = true;
    } else if (strcmp(argv[i], "-htr")==0) {
      opt.HyperGraphBasedTRClustering = true;
    } else if (strcmp(argv[i], "-qr")==0) {
      opt.ClusterMethod = Options::QR;
    } else if (strcmp(argv[i], "-bq0")==0) {
      opt.ClusterMethod = Options::BQ;
    } else if (strcmp(argv[i], "-bq1")==0) {
      opt.ClusterMethod = Options::BQ;
      opt.InvertedClusters = true;
    } else if (strcmp(argv[i], "-bq2")==0) {
      opt.ClusterMethod = Options::BQ;
      opt.InvertedVars = false;
    } else if (strcmp(argv[i], "-bq3")==0) {
      opt.ClusterMethod = Options::BQ;
      opt.InvertedVars = false;
      opt.InvertedClusters = true;
    } else if (strcmp(argv[i], "-bu")==0) {
      opt.ClusterMethod = Options::EASYBUCKET;
    } else if (strcmp(argv[i], "-hvo")==0) {
      opt.HyperGraphBasedVariableOrdering = true;
    } else if (strncmp(argv[i], "-d", 2)==0) {
      strcpy(opt.debugDump, &argv[i][2]);
    } else if (strncmp(argv[i], "-log", 2)==0) {
      opt.Log = true;
    } else {
      break;
    }
  }

  opt.iClusterThreshold = 1000;

  if (i==argc) return -1;
  return i;
}

int main(int argc, char **argv)
{
  KSATChecker ksat;
  int fn;
  sizelog = NULL;
  DefaultOptions(ksat.opt);
  bool usesizelog = (sizelog != NULL);
  fn=ParseOptions(argc, argv, ksat.opt);

  if (fn!=-1) {
    ksat.Main(argv[fn]);
    if (usesizelog) {
      fclose(sizelog);
    }
  }
  else
    return -1;
  return 0;  
}
