/* *********************************************************************** */
/* *********************************************************************** */

/* FILE tptp.lex - *SAT 1.3 */ 
/* Lexical analyzer for the formula file (TPTP syntax) */

/* *********************************************************************** */
/* *********************************************************************** */

%{
#include <stdio.h>
#include <string.h>

#include "tptp.h"

int yywrap()
{
return 1;
}

int  number;
char name[256];
%}

%START COMMENT

%%

[ \t\n] ;    
"("     return LP;
")"     return RP; 
":"     return COL;
"box"   return BOX;         
"pos"   return POS;
"&"     return AND; 
"|"     return OR;
"=>"    return IMP;
"~"     return NOT;
"true"  return TTRUE;
"false" return TFALSE;
"v"     return VAR;
"r"     return RULE;

"inputformula" return INWFF;
"hypothesis,"  return HYP;
"conjecture,"  return CONJ;
"."            return DOT;

0|[1-9][0-9]* {   
  sscanf(tptptext,"%d",&number);
  tptplval.l=number;
  return NUM;
}

[A-Za-z][A-Za-z0-9_]*, { 
  sscanf(tptptext,"%s",name); 
  strcpy(tptplval.s,name);  
  return IDENT;
}
\%[^\n]*\n ;
.  { 
  /* Error function */
  fprintf(stderr,"Illegal character %s	\n",yytext);
  return -1;
}
%%








