/*  *********************************************************************** */
/*  *********************************************************************** */

/*  FILE alc.y - *SAT 1.3 */ 
/*  Grammar for the formula file (TPTP syntax) */

/*  *********************************************************************** */
/*  *********************************************************************** */

%{
#include "Formula.h"

#define YYMAXDEPTH 1000000
#define YYDEBUG 1

  enum tptp_lexer_symbols {and_code=OP_AND, or_code=OP_OR, not_code=OP_NOT, top_code=OP_TOP, bot_code=OP_BOTTOM, imp_code, iff_code, dia_code=OP_DIAMOND, box_code=OP_BOX};

  extern void *parser_formula;

%}

%union {
   int     l;
   char    s[256];
   void *f; 
}

/* Tokens and types */

%token LP RP COL
%token INWFF HYP CONJ DOT 
%token BOX POS AND OR IMP NOT TFALSE TTRUE
%token VAR RULE
%token <l> NUM 
%token <s> IDENT

%type <f> decl_list declaration
%type <f> formula complex_formula formula_list atom
%type <l> bool_op rule_op

%% /* Grammar rules */

input: decl_list
{parser_formula = $1;}
;

decl_list: INWFF declaration decl_list
{$$ = build_formula($2, OP_AND, 0, $3);}
| INWFF declaration
{$$ = $2;}
;

declaration: LP IDENT HYP formula RP DOT 
{$$ = $4;}
| LP IDENT CONJ formula RP DOT
{$$ = build_formula($4, OP_NOT, 0, NULL);}
;

formula: complex_formula  
{$$ = $1;}
| atom 
{$$ = $1;}
;

complex_formula: LP rule_op RULE NUM COL formula RP
{$$ = build_formula($6, $2, $4, NULL);}
| NOT formula 
{$$ = build_formula($2, OP_NOT, 0,NULL);}
| LP formula_list RP
{$$ = $2;}
;

formula_list: formula bool_op formula_list
{
  if ((int)$2==imp_code) {
    void *temp=build_formula($1, OP_NOT, 0, NULL);
    $$ = build_formula(temp, OP_OR, 0, $3);
  } else if ((int)$3==iff_code) {
    void *temp1, *temp2, *temp3, *temp4, *clone2, *clone3;
    clone2=clone_formula((void *)$1);
    clone3=clone_formula((void *)$3);
    temp1=build_formula(clone2, OP_NOT, 0, NULL);
    temp2=build_formula(clone3, OP_NOT, 0, NULL);
    temp3=build_formula(temp1, OP_OR, 0, $3);
    temp4=build_formula(temp2, OP_OR, 0, $1);
    $$=build_formula(temp3, OP_AND, 0, temp4);
  } else {
    $$ = build_formula($1, $2, 0, $3);
  }
}
| formula
{$$ = $1;}
;

atom: VAR NUM
{$$ = build_formula(NULL, OP_PROP, $2, NULL);}
| TTRUE
{$$ = build_formula(NULL, OP_TOP, 0, NULL);}
| TFALSE 
{$$ = build_formula(NULL, OP_BOTTOM, 0, NULL);}
;

bool_op: AND {$$ = and_code;} 
|        OR  {$$ = or_code;} 
|        IMP {$$ = imp_code;} 
;

rule_op: POS {$$ = dia_code;}
|        BOX {$$ = box_code;}       

%% /* End of grammar rules */

int yyerror(char *s) 
{
  printf("%s\n", s);
  exit(0);
}







