#ifndef __RGL_ASTAR_H__
#define __RGL_ASTAR_H__

#include "graph.h"

BEGIN_C_DECL

typedef double (*cost_fn_t)(pointer_t, int, int);
typedef double (*estimate_fn_t)(pointer_t, int);

/**
 * Computes a path between two vertices in a graph using the A-star heuristic.
 *
 * @param graph a (directed?) graph over a set of keys.
 * @param start the starting vertex for the path.
 * @param finish the finish vertex for the path.
 * @param cost_fn a cost function for the graph.
 * @param estimate_fn a distance metric for A-star.
 * @param cost_data the pointer passed to the cost function when its called.
 * @param estimate_data the pointer passed to the distance function when its called.
 * @param len will be set to the length of the final path or zero if no path.
 * @param path will be set to an array of length len or NULL if no path.
 *
 * @return total path cost.
 */

double get_shortest_path_astar(graph_t graph, int start, int finish, 
			       cost_fn_t cost_fn, estimate_fn_t estimate_fn,
			       pointer_t cost_data, pointer_t estimate_data,
			       int *len, int **path);

END_C_DECL

#endif
