#ifndef ____FAST__UNION__H___
#define ____FAST__UNION__H___

#include "defs.h"

BEGIN_C_DECL

typedef struct fast_union
{
  struct fast_union *parent;

  int rank;
  int id;
} fast_union_t;

/**
 * Allocates a fast union object.
 */

fast_union_t *alloc_fast_union(int id);

/**
 * Frees a fast union object.  Somewhat unsafe - freeing a representative is fatal.
 */

void free_fast_union(fast_union_t *fu);

/**
 * Computes the union between two sets.
 */

void union_fast_union(fast_union_t *a, fast_union_t *b);

/**
 * Returns the representative of two unions.
 */

int representative_fast_union(fast_union_t *fu);

END_C_DECL


#endif
