#ifndef ___RGL_FBHEAP_H___
#define ___RGL_FBHEAP_H___

#include "bheap.h"

BEGIN_C_DECL

/**
 * Faster minimizing binary heaps that do not support look up operations.
 */

typedef int * fbheap_t;

/**
 * Allocates an fast binary heap.
 *
 * @param cmp_fn a comparator.
 * @param data to be passed to the comparator.
 *
 * @return a fresh heap.
 */

fbheap_t alloc_fbheap(cmp_fn_t cmp_fn, pointer_t data);

/**
 * Frees a fast binary heap.
 */

void free_fbheap(fbheap_t heap);

/**
 * Size of a fast binary heap.
 */

int size_fbheap(fbheap_t heap);

/**
 * Puts a key into a fast binary heap.  Note a single key can be added multiple times.
 *
 * @param heap the heap
 * @param key a key.
 *
 * @return the new fast binary heap (might be different).
 */

fbheap_t put_fbheap(fbheap_t heap, int key);

/**
 * Extracts an element from a fast binary heap.
 *
 * @return the element extracted.
 */

int extract_fbheap(fbheap_t heap);

/**
 * Returns the smallest element in the heap.
 */

int top_fbheap(fbheap_t heap);

/**
 * Heapsort with fast binary heaps.
 */

void heapsort_fbheap(int *elts, int len, cmp_fn_t cmp_fn, pointer_t data);

END_C_DECL

#endif
